/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.cli;

import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.brooklyn.core.entity.factory.ApplicationBuilder;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public class BaseCliIntegrationTest {
    private static final String BROOKLYN_BIN_PATH = "./target/brooklyn-dist/bin/brooklyn";
    private static final String BROOKLYN_CLASSPATH = "./target/test-classes/:./target/classes/";
    private static final long DELAY = 10L;
    private static final long TIMEOUT = 40L;
    private ExecutorService executor;

    @BeforeMethod(alwaysRun=true)
    public void setup() {
        this.executor = Executors.newCachedThreadPool();
    }

    @AfterMethod(alwaysRun=true)
    public void teardown() {
        this.executor.shutdownNow();
    }

    public Process startBrooklyn(String ... argv) throws Throwable {
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.environment().remove("BROOKLYN_HOME");
        pb.environment().put("BROOKLYN_CLASSPATH", BROOKLYN_CLASSPATH);
        pb.command(Lists.asList((Object)BROOKLYN_BIN_PATH, (Object[])argv));
        return pb.start();
    }

    public void testBrooklyn(Process brooklyn, BrooklynCliTest test, int expectedExit) throws Throwable {
        this.testBrooklyn(brooklyn, test, expectedExit, false);
    }

    public void testBrooklyn(Process brooklyn, BrooklynCliTest test, int expectedExit, boolean stop) throws Throwable {
        try {
            Future<Integer> future = this.executor.submit(test);
            if (stop) {
                OutputStream out = brooklyn.getOutputStream();
                out.write(10);
                out.flush();
            }
            int exitStatus = future.get(40L, TimeUnit.SECONDS);
            Assert.assertEquals((int)exitStatus, (int)expectedExit, (String)"Command returned wrong status");
        }
        catch (TimeoutException te) {
            Assert.fail((String)"Timed out waiting for process to complete", (Throwable)te);
        }
        catch (ExecutionException ee) {
            if (ee.getCause() instanceof AssertionError) {
                throw ee.getCause();
            }
            throw ee;
        }
        finally {
            brooklyn.destroy();
        }
    }

    public static class TestApplication
    extends ApplicationBuilder {
        protected void doBuild() {
        }
    }

    public static abstract class BrooklynCliTest
    implements Callable<Integer> {
        private final Process brooklyn;
        private String consoleOutput;
        private String consoleError;

        public BrooklynCliTest(Process brooklyn) {
            this.brooklyn = brooklyn;
        }

        @Override
        public Integer call() throws Exception {
            Thread.sleep(TimeUnit.SECONDS.toMillis(10L));
            this.consoleOutput = this.convertStreamToString(this.brooklyn.getInputStream());
            this.consoleError = this.convertStreamToString(this.brooklyn.getErrorStream());
            this.checkConsole();
            return this.brooklyn.waitFor();
        }

        public abstract void checkConsole();

        private String convertStreamToString(InputStream is) {
            try {
                return new Scanner(is).useDelimiter("\\A").next();
            }
            catch (NoSuchElementException e) {
                return "";
            }
        }

        protected void assertConsoleOutput(String ... expected) {
            for (String e : expected) {
                Assert.assertTrue((boolean)this.consoleOutput.contains(e), (String)("Execution output not logged; output=" + this.consoleOutput));
            }
        }

        protected void assertNoConsoleOutput(String ... expected) {
            for (String e : expected) {
                Assert.assertFalse((boolean)this.consoleOutput.contains(e), (String)("Execution output logged; output=" + this.consoleOutput));
            }
        }

        protected void assertConsoleError(String ... expected) {
            for (String e : expected) {
                Assert.assertTrue((boolean)this.consoleError.contains(e), (String)("Execution error not logged; error=" + this.consoleError));
            }
        }

        protected void assertNoConsoleError(String ... expected) {
            for (String e : expected) {
                Assert.assertFalse((boolean)this.consoleError.contains(e), (String)("Execution error logged; error=" + this.consoleError));
            }
        }

        protected void assertConsoleOutputEmpty() {
            Assert.assertTrue((boolean)this.consoleOutput.isEmpty(), (String)("Output present; output=" + this.consoleOutput));
        }

        protected void assertConsoleErrorEmpty() {
            Assert.assertTrue((boolean)this.consoleError.isEmpty(), (String)("Error present; error=" + this.consoleError));
        }
    }
}

