/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.router;

import io.netty.buffer.ByteBuf;
import org.apache.bookkeeper.common.hash.MurmurHash;
import org.apache.bookkeeper.common.router.HashRouter;

public abstract class AbstractHashRouter<K>
implements HashRouter<K> {
    private static final long serialVersionUID = -7979076779920023308L;
    static final long HASH_SEED = 383242705L;

    protected AbstractHashRouter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long getRoutingKey(K key) {
        ByteBuf keyData = this.getRoutingKeyData(key);
        try {
            Long l = MurmurHash.hash64(keyData, keyData.readerIndex(), keyData.readableBytes(), 383242705L);
            return l;
        }
        finally {
            keyData.release();
        }
    }

    abstract ByteBuf getRoutingKeyData(K var1);
}

