/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.resolver;

import com.google.common.collect.Lists;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.bookkeeper.common.resolver.AbstractNameResolver;
import org.apache.bookkeeper.common.util.SharedResourceManager;

public class SimpleNameResolver
extends AbstractNameResolver {
    private final List<EquivalentAddressGroup> servers;

    public SimpleNameResolver(String name, SharedResourceManager.Resource<ExecutorService> executorResource, List<URI> endpoints) {
        super(name, executorResource);
        this.servers = Collections.unmodifiableList(endpoints.stream().map(endpoint -> new EquivalentAddressGroup((List)Lists.newArrayList((Object[])new SocketAddress[]{new InetSocketAddress(endpoint.getHost(), endpoint.getPort())}), Attributes.EMPTY)).collect(Collectors.toList()));
    }

    @Override
    public List<EquivalentAddressGroup> getServers() {
        return this.servers;
    }
}

