/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.coder;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import org.apache.bookkeeper.common.coder.Coder;

public final class StringUtf8Coder
implements Coder<String> {
    private static final StringUtf8Coder INSTANCE = new StringUtf8Coder();

    public static StringUtf8Coder of() {
        return INSTANCE;
    }

    @Override
    public byte[] encode(String value) {
        return value.getBytes(Charsets.UTF_8);
    }

    @Override
    public void encode(String value, ByteBuf destBuf) {
        destBuf.writeCharSequence((CharSequence)value, Charsets.UTF_8);
    }

    @Override
    public int getSerializedSize(String value) {
        return value.length();
    }

    @Override
    public String decode(byte[] data) {
        return new String(data, Charsets.UTF_8);
    }

    @Override
    public String decode(ByteBuf data) {
        byte[] bytes = ByteBufUtil.getBytes((ByteBuf)data);
        return this.decode(bytes);
    }

    private StringUtf8Coder() {
    }
}

