/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common.router;

import com.google.common.base.Charsets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import org.apache.bookkeeper.common.router.AbstractHashRouter;
import org.apache.bookkeeper.common.router.HashRouter;

public class StringUtf8HashRouter
extends AbstractHashRouter<String> {
    private static final long serialVersionUID = -4630305722027547668L;
    private static final StringUtf8HashRouter ROUTER = new StringUtf8HashRouter();

    public static HashRouter<String> of() {
        return ROUTER;
    }

    private StringUtf8HashRouter() {
    }

    @Override
    public ByteBuf getRoutingKeyData(String key) {
        int keyLen = key.length();
        ByteBuf keyBuf = PooledByteBufAllocator.DEFAULT.buffer(keyLen);
        keyBuf.writeCharSequence((CharSequence)key, Charsets.UTF_8);
        return keyBuf;
    }
}

