/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.twitter.science;

import com.twitter.common.stats.RequestStats;
import com.twitter.common.stats.Stat;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.OpStatsData;
import org.apache.bookkeeper.stats.OpStatsLogger;

public class OpStatsLoggerImpl
implements OpStatsLogger {
    private final RequestStats events;

    public OpStatsLoggerImpl(String name) {
        this.events = new RequestStats(name);
    }

    public void registerFailedEvent(long eventLatency, TimeUnit unit) {
        this.events.incErrors(unit.toMicros(eventLatency));
    }

    public void registerSuccessfulEvent(long eventLatency, TimeUnit unit) {
        this.events.requestComplete(unit.toMicros(eventLatency));
    }

    public void registerSuccessfulValue(long value) {
        this.events.requestComplete(TimeUnit.MILLISECONDS.toMicros(value));
    }

    public void registerFailedValue(long value) {
        this.events.incErrors(TimeUnit.MILLISECONDS.toMicros(value));
    }

    public synchronized void clear() {
    }

    public synchronized OpStatsData toOpStatsData() {
        long numFailed = this.events.getErrorCount();
        long numSuccess = this.events.getSlidingStats().getEventCounter().get() - numFailed;
        double avgLatencyMillis = (Double)this.events.getSlidingStats().getPerEventLatency().read() / 1000.0;
        double[] defaultPercentiles = new double[]{10.0, 50.0, 90.0, 99.0, 99.9, 99.99};
        long[] latenciesMillis = new long[defaultPercentiles.length];
        Arrays.fill(latenciesMillis, Long.MAX_VALUE);
        Map realPercentileLatencies = this.events.getPercentile().getPercentiles();
        for (int i = 0; i < defaultPercentiles.length; ++i) {
            if (!realPercentileLatencies.containsKey(defaultPercentiles[i])) continue;
            Stat latency = (Stat)realPercentileLatencies.get(defaultPercentiles[i]);
            latenciesMillis[i] = TimeUnit.MICROSECONDS.toMillis(((Double)latency.read()).longValue());
        }
        return new OpStatsData(numSuccess, numFailed, avgLatencyMillis, latenciesMillis);
    }
}

