/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.twitter.science;

import org.apache.bookkeeper.stats.CachingStatsProvider;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.stats.twitter.science.HTTPStatsExporter;
import org.apache.bookkeeper.stats.twitter.science.TwitterStatsLoggerImpl;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitterStatsProvider
implements StatsProvider {
    static final Logger LOG = LoggerFactory.getLogger(TwitterStatsProvider.class);
    protected static final String STATS_EXPORT = "statsExport";
    protected static final String STATS_HTTP_PORT = "statsHttpPort";
    private HTTPStatsExporter statsExporter = null;
    private final CachingStatsProvider cachingStatsProvider = new CachingStatsProvider(new StatsProvider(){

        public void start(Configuration conf) {
        }

        public void stop() {
        }

        public StatsLogger getStatsLogger(String scope) {
            return new TwitterStatsLoggerImpl(scope);
        }

        public String getStatsName(String ... statsComponents) {
            return StringUtils.join((Object[])statsComponents, (char)'_').toLowerCase();
        }
    });

    public void start(Configuration conf) {
        if (conf.getBoolean(STATS_EXPORT, false)) {
            this.statsExporter = new HTTPStatsExporter(conf.getInt(STATS_HTTP_PORT, 9002));
        }
        if (null != this.statsExporter) {
            try {
                this.statsExporter.start();
            }
            catch (Exception e) {
                LOG.error("Fail to start stats exporter : ", (Throwable)e);
            }
        }
    }

    public void stop() {
        if (null != this.statsExporter) {
            try {
                this.statsExporter.stop();
            }
            catch (Exception e) {
                LOG.error("Fail to stop stats exporter : ", (Throwable)e);
            }
        }
    }

    public StatsLogger getStatsLogger(String name) {
        return this.cachingStatsProvider.getStatsLogger(name);
    }

    public String getStatsName(String ... statsComponents) {
        return this.cachingStatsProvider.getStatsName(statsComponents);
    }
}

