/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.twitter.science;

import com.twitter.common.stats.Rate;
import com.twitter.common.stats.Stat;
import com.twitter.common.stats.Stats;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.stats.Counter;

public class CounterImpl
implements Counter {
    private String name;
    private AtomicLong value;

    public CounterImpl(String name) {
        this.name = name;
        this.value = new AtomicLong(0L);
        this.setUpStatsExport();
    }

    public synchronized void clear() {
        this.value.getAndSet(0L);
    }

    public Long get() {
        return this.value.get();
    }

    private void setUpStatsExport() {
        Stats.export((String)this.name, (AtomicLong)this.value);
        Stats.export((Stat)Rate.of((String)(this.name + "_per_sec"), (AtomicLong)this.value).build());
    }

    public void inc() {
        this.value.incrementAndGet();
    }

    public void dec() {
        this.value.decrementAndGet();
    }

    public void add(long delta) {
        this.value.addAndGet(delta);
    }
}

