/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.twitter.science;

import com.twitter.common.stats.SampledStat;
import com.twitter.common.stats.Stat;
import com.twitter.common.stats.Stats;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.twitter.science.CounterImpl;
import org.apache.bookkeeper.stats.twitter.science.OpStatsLoggerImpl;

public class TwitterStatsLoggerImpl
implements StatsLogger {
    protected final String name;

    public TwitterStatsLoggerImpl(String name) {
        this.name = name;
    }

    public OpStatsLogger getOpStatsLogger(String statName) {
        return new OpStatsLoggerImpl(this.getStatName(statName));
    }

    public Counter getCounter(String statName) {
        return new CounterImpl(this.getStatName(statName));
    }

    public <T extends Number> void registerGauge(String statName, final Gauge<T> gauge) {
        Stats.export((Stat)new SampledStat<Number>(this.getStatName(statName), gauge.getDefaultValue()){

            public T doSample() {
                return gauge.getSample();
            }
        });
    }

    public <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
    }

    private String getStatName(String statName) {
        return (this.name + "_" + statName).toLowerCase();
    }

    public StatsLogger scope(String scope) {
        String scopeName = 0 == this.name.length() ? scope : this.name + "_" + scope;
        return new TwitterStatsLoggerImpl(scopeName);
    }

    public void removeScope(String name, StatsLogger statsLogger) {
    }
}

