/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.twitter.science;

import com.twitter.common.application.ShutdownRegistry;
import com.twitter.common.base.Supplier;
import com.twitter.common.net.http.handlers.VarsHandler;
import com.twitter.common.net.http.handlers.VarsJsonHandler;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.stats.JvmStats;
import com.twitter.common.stats.Stat;
import com.twitter.common.stats.Stats;
import com.twitter.common.stats.TimeSeriesRepositoryImpl;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;

public class HTTPStatsExporter {
    final Server jettyServer;
    final ShutdownRegistry.ShutdownRegistryImpl shutDownRegistry = new ShutdownRegistry.ShutdownRegistryImpl();
    final int port;

    public HTTPStatsExporter(int port) {
        this.port = port;
        this.jettyServer = new Server(port);
    }

    public void start() throws Exception {
        TimeSeriesRepositoryImpl sampler = new TimeSeriesRepositoryImpl(Stats.STAT_REGISTRY, Amount.of((long)1L, (Unit)Time.SECONDS), Amount.of((long)1L, (Unit)Time.HOURS));
        sampler.start((ShutdownRegistry)this.shutDownRegistry);
        JvmStats.export();
        Supplier supplier = new Supplier<Iterable<Stat<?>>>(){

            public Iterable<Stat<?>> get() {
                return Stats.getVariables();
            }
        };
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        this.jettyServer.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new VarsHandler((com.google.common.base.Supplier)supplier)), "/vars");
        context.addServlet(new ServletHolder((Servlet)new VarsJsonHandler((com.google.common.base.Supplier)supplier)), "/vars.json");
        this.jettyServer.start();
    }

    public void stop() throws Exception {
        this.jettyServer.stop();
        if (this.shutDownRegistry != null) {
            this.shutDownRegistry.execute();
        }
    }
}

