/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.twitter.ostrich;

import com.twitter.ostrich.stats.Counter;
import com.twitter.ostrich.stats.Distribution;
import com.twitter.ostrich.stats.Histogram;
import com.twitter.ostrich.stats.Metric;
import com.twitter.ostrich.stats.StatsProvider;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.OpStatsData;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OpStatsLoggerImpl
implements OpStatsLogger {
    static final Logger LOG = LoggerFactory.getLogger(OpStatsLoggerImpl.class);
    static final double[] PERCENTILES = new double[]{0.1, 0.5, 0.9, 0.99, 0.999, 0.9999};
    private final String scope;
    private final Counter successCounter;
    private final Counter failureCounter;
    private final Metric successMetric;
    private final Metric failureMetric;

    OpStatsLoggerImpl(String scope, StatsProvider statsProvider) {
        this.scope = scope;
        this.successCounter = statsProvider.getCounter(this.statName("requests/success"));
        this.failureCounter = statsProvider.getCounter(this.statName("requests/failure"));
        this.successMetric = statsProvider.getMetric(this.statName("latency/success"));
        this.failureMetric = statsProvider.getMetric(this.statName("latency/failure"));
    }

    private String statName(String statName) {
        return String.format("%s/%s", this.scope, statName);
    }

    public void registerFailedEvent(long eventLatency, TimeUnit unit) {
        if (eventLatency < 0L) {
            LOG.debug("{} : tried to register negative failure", (Object)this.scope);
        } else {
            this.failureMetric.add((int)unit.toMillis(eventLatency));
            this.failureCounter.incr();
        }
    }

    public void registerSuccessfulEvent(long eventLatency, TimeUnit unit) {
        if (eventLatency < 0L) {
            LOG.debug("{} : tried to register negative success", (Object)this.scope);
        } else {
            this.successMetric.add((int)unit.toMillis(eventLatency));
            this.successCounter.incr();
        }
    }

    public void registerSuccessfulValue(long value) {
        if (value < 0L) {
            LOG.debug("{} : tried to register negative success", (Object)this.scope);
        } else {
            this.successMetric.add((int)value);
            this.successCounter.incr();
        }
    }

    public void registerFailedValue(long value) {
        if (value < 0L) {
            LOG.debug("{} : tried to register negative success", (Object)this.scope);
        } else {
            this.failureMetric.add((int)value);
            this.failureCounter.incr();
        }
    }

    public OpStatsData toOpStatsData() {
        long numSuccess = this.successCounter.apply();
        long numFailures = this.failureCounter.apply();
        Distribution distribution = this.successMetric.apply();
        Histogram histogram = distribution.histogram();
        double avgLatency = distribution.average();
        long[] percentiles = new long[PERCENTILES.length];
        int i = 0;
        for (double percentile : PERCENTILES) {
            percentiles[i] = histogram.getPercentile(percentile);
            ++i;
        }
        return new OpStatsData(numSuccess, numFailures, avgLatency, percentiles);
    }

    public void clear() {
        this.successCounter.reset();
        this.failureCounter.reset();
        this.successMetric.clear();
        this.failureMetric.clear();
    }
}

