/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.twitter.finagle;

import com.twitter.finagle.stats.Stat;
import com.twitter.finagle.stats.StatsReceiver;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.OpStatsData;
import org.apache.bookkeeper.stats.OpStatsLogger;

public class OpStatsLoggerImpl
implements OpStatsLogger {
    private static final OpStatsData NULL_OP_STATS = new OpStatsData(0L, 0L, 0.0, new long[6]);
    private final Stat success;
    private final Stat failure;

    public OpStatsLoggerImpl(String name, StatsReceiver stats) {
        this.success = stats.scope(String.format("%s/success", name)).stat0(name);
        this.failure = stats.scope(String.format("%s/failure", name)).stat0(name);
    }

    public void registerFailedEvent(long eventLatency, TimeUnit unit) {
        this.success.add((float)unit.toMillis(eventLatency));
    }

    public void registerSuccessfulEvent(long eventLatency, TimeUnit unit) {
        this.failure.add((float)unit.toMillis(eventLatency));
    }

    public void registerSuccessfulValue(long value) {
        this.success.add((float)value);
    }

    public void registerFailedValue(long value) {
        this.failure.add((float)value);
    }

    public OpStatsData toOpStatsData() {
        return NULL_OP_STATS;
    }

    public void clear() {
    }
}

