/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.twitter.finagle;

import com.twitter.finagle.stats.StatsReceiver;
import com.twitter.util.Function0;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.twitter.finagle.CounterImpl;
import org.apache.bookkeeper.stats.twitter.finagle.OpStatsLoggerImpl;
import scala.collection.JavaConversions;
import scala.collection.Seq;
import scala.collection.immutable.List;

public class FinagleStatsLoggerImpl
implements StatsLogger {
    private final StatsReceiver stats;
    final Map<Gauge, com.twitter.finagle.stats.Gauge> finagleGauges;

    public FinagleStatsLoggerImpl(StatsReceiver stats) {
        this.stats = stats;
        this.finagleGauges = new HashMap<Gauge, com.twitter.finagle.stats.Gauge>();
    }

    public OpStatsLogger getOpStatsLogger(String name) {
        return new OpStatsLoggerImpl(name, this.stats);
    }

    public Counter getCounter(String name) {
        return new CounterImpl(name, this.stats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Number> void registerGauge(String name, Gauge<T> gauge) {
        List gaugeName = JavaConversions.asScalaBuffer(Arrays.asList(name)).toList();
        Map<Gauge, com.twitter.finagle.stats.Gauge> map = this.finagleGauges;
        synchronized (map) {
            this.finagleGauges.put(gauge, this.stats.addGauge((Seq)gaugeName, this.gaugeProvider(gauge)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
        Map<Gauge, com.twitter.finagle.stats.Gauge> map = this.finagleGauges;
        synchronized (map) {
            this.finagleGauges.remove(gauge);
        }
    }

    private <T extends Number> Function0<Object> gaugeProvider(final Gauge<T> gauge) {
        return new Function0<Object>(){

            public Object apply() {
                return Float.valueOf(gauge.getSample().floatValue());
            }
        };
    }

    public StatsLogger scope(String name) {
        return new FinagleStatsLoggerImpl(this.stats.scope(name));
    }

    public void removeScope(String name, StatsLogger statsLogger) {
    }
}

