/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.prometheus;

import com.google.common.base.Joiner;
import io.prometheus.client.Collector;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.Gauge;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.prometheus.DataSketchesOpStatsLogger;
import org.apache.bookkeeper.stats.prometheus.LongAdderCounter;
import org.apache.bookkeeper.stats.prometheus.PrometheusMetricsProvider;
import org.apache.bookkeeper.stats.prometheus.SimpleGauge;

public class PrometheusStatsLogger
implements StatsLogger {
    private final PrometheusMetricsProvider provider;
    private final String scope;

    PrometheusStatsLogger(PrometheusMetricsProvider provider, String scope) {
        this.provider = provider;
        this.scope = scope;
    }

    public OpStatsLogger getOpStatsLogger(String name) {
        return this.provider.opStats.computeIfAbsent(this.completeName(name), x -> new DataSketchesOpStatsLogger());
    }

    public Counter getCounter(String name) {
        return this.provider.counters.computeIfAbsent(this.completeName(name), x -> new LongAdderCounter());
    }

    public <T extends Number> void registerGauge(String name, Gauge<T> gauge) {
        this.provider.gauges.computeIfAbsent(this.completeName(name), x -> new SimpleGauge(gauge));
    }

    public <T extends Number> void unregisterGauge(String name, Gauge<T> gauge) {
    }

    public void removeScope(String name, StatsLogger statsLogger) {
    }

    public StatsLogger scope(String name) {
        return new PrometheusStatsLogger(this.provider, this.completeName(name));
    }

    private String completeName(String name) {
        String completeName = this.scope.isEmpty() ? name : Joiner.on((char)'_').join((Object)this.scope, (Object)name, new Object[0]);
        return Collector.sanitizeMetricName((String)completeName);
    }
}

