/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.prometheus;

import com.google.common.annotations.VisibleForTesting;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.PlatformDependent;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Gauge;
import io.prometheus.client.hotspot.GarbageCollectorExports;
import io.prometheus.client.hotspot.MemoryPoolsExports;
import io.prometheus.client.hotspot.StandardExports;
import io.prometheus.client.hotspot.ThreadExports;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Servlet;
import org.apache.bookkeeper.stats.CachingStatsProvider;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.stats.prometheus.DataSketchesOpStatsLogger;
import org.apache.bookkeeper.stats.prometheus.LongAdderCounter;
import org.apache.bookkeeper.stats.prometheus.PrometheusServlet;
import org.apache.bookkeeper.stats.prometheus.PrometheusStatsLogger;
import org.apache.bookkeeper.stats.prometheus.PrometheusTextFormatUtil;
import org.apache.bookkeeper.stats.prometheus.SimpleGauge;
import org.apache.commons.configuration.Configuration;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrometheusMetricsProvider
implements StatsProvider {
    private ScheduledExecutorService executor;
    private static final String PROMETHEUS_STATS_HTTP_PORT = "prometheusStatsHttpPort";
    private static final int DEFAULT_PROMETHEUS_STATS_HTTP_PORT = 8000;
    private static final String PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = "prometheusStatsLatencyRolloverSeconds";
    private static final int DEFAULT_PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS = 60;
    final CollectorRegistry registry = new CollectorRegistry();
    private Server server;
    private final CachingStatsProvider cachingStatsProvider;
    final ConcurrentMap<String, LongAdderCounter> counters = new ConcurrentSkipListMap<String, LongAdderCounter>();
    final ConcurrentMap<String, SimpleGauge<? extends Number>> gauges = new ConcurrentSkipListMap<String, SimpleGauge<? extends Number>>();
    final ConcurrentMap<String, DataSketchesOpStatsLogger> opStats = new ConcurrentSkipListMap<String, DataSketchesOpStatsLogger>();
    private static final Logger log = LoggerFactory.getLogger(PrometheusMetricsProvider.class);
    private static final AtomicLong directMemoryUsage;

    public PrometheusMetricsProvider() {
        this.cachingStatsProvider = new CachingStatsProvider(new StatsProvider(){

            public void start(Configuration conf) {
            }

            public void stop() {
            }

            public StatsLogger getStatsLogger(String scope) {
                return new PrometheusStatsLogger(PrometheusMetricsProvider.this, scope);
            }
        });
    }

    public void start(Configuration conf) {
        int httpPort = conf.getInt(PROMETHEUS_STATS_HTTP_PORT, 8000);
        InetSocketAddress httpEndpoint = InetSocketAddress.createUnresolved("0.0.0.0", httpPort);
        this.server = new Server(httpEndpoint);
        ServletContextHandler context = new ServletContextHandler();
        context.setContextPath("/");
        this.server.setHandler((Handler)context);
        context.addServlet(new ServletHolder((Servlet)new PrometheusServlet(this)), "/metrics");
        try {
            this.server.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        new StandardExports().register(this.registry);
        new MemoryPoolsExports().register(this.registry);
        new GarbageCollectorExports().register(this.registry);
        new ThreadExports().register(this.registry);
        Gauge.build((String)"jvm_memory_direct_bytes_used", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return directMemoryUsage != null ? (double)directMemoryUsage.longValue() : Double.NaN;
            }
        }, new String[0]).register(this.registry);
        Gauge.build((String)"jvm_memory_direct_bytes_max", (String)"-").create().setChild((Object)new Gauge.Child(){

            public double get() {
                return PlatformDependent.maxDirectMemory();
            }
        }, new String[0]).register(this.registry);
        this.executor = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new DefaultThreadFactory("metrics"));
        int latencyRolloverSeconds = conf.getInt(PROMETHEUS_STATS_LATENCY_ROLLOVER_SECONDS, 60);
        this.executor.scheduleAtFixedRate(() -> this.rotateLatencyCollection(), 1L, latencyRolloverSeconds, TimeUnit.SECONDS);
        log.info("Started Prometheus stats endpoint at {}", (Object)httpEndpoint);
    }

    public void stop() {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                log.warn("Failed to shutdown Jetty server", (Throwable)e);
            }
        }
    }

    public StatsLogger getStatsLogger(String scope) {
        return this.cachingStatsProvider.getStatsLogger(scope);
    }

    @VisibleForTesting
    void writeAllMetrics(Writer writer) throws IOException {
        PrometheusTextFormatUtil.writeMetricsCollectedByPrometheusClient(writer, this.registry);
        this.gauges.forEach((name, gauge) -> PrometheusTextFormatUtil.writeGauge(writer, name, gauge));
        this.counters.forEach((name, counter) -> PrometheusTextFormatUtil.writeCounter(writer, name, counter));
        this.opStats.forEach((name, opStatLogger) -> PrometheusTextFormatUtil.writeOpStat(writer, name, opStatLogger));
    }

    @VisibleForTesting
    void rotateLatencyCollection() {
        this.opStats.forEach((name, metric) -> metric.rotateLatencyCollection());
    }

    static {
        AtomicLong tmpDirectMemoryUsage = null;
        try {
            Field field = PlatformDependent.class.getDeclaredField("DIRECT_MEMORY_COUNTER");
            field.setAccessible(true);
            tmpDirectMemoryUsage = (AtomicLong)field.get(null);
        }
        catch (Throwable t) {
            log.warn("Failed to access netty DIRECT_MEMORY_COUNTER field {}", (Object)t.getMessage());
        }
        directMemoryUsage = tmpDirectMemoryUsage;
    }
}

