/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@Threads(value=16)
@Fork(value=1)
@Warmup(iterations=1, time=10, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=3, time=10, timeUnit=TimeUnit.SECONDS)
public class OrderedExecutorBenchmark {
    private static Map<String, Supplier<ExecutorService>> providers = ImmutableMap.of((Object)"JDK-ThreadPool", () -> Executors.newFixedThreadPool(1), (Object)"OrderedExecutor", () -> OrderedExecutor.newBuilder().numThreads(1).build(), (Object)"OrderedScheduler", () -> (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(1).build());

    @Benchmark
    public void submitAndWait(TestState s) throws Exception {
        s.executor.submit(() -> {}).get();
    }

    @State(value=Scope.Benchmark)
    public static class TestState {
        @Param(value={"JDK-ThreadPool", "OrderedExecutor", "OrderedScheduler"})
        private String executorName;
        private ExecutorService executor;

        @Setup(value=Level.Trial)
        public void setup() {
            this.executor = (ExecutorService)((Supplier)providers.get(this.executorName)).get();
        }

        @TearDown(value=Level.Trial)
        public void teardown() {
            this.executor.shutdown();
        }
    }
}

