/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.bookkeeper.stats.Counter;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.StatsProvider;
import org.apache.bookkeeper.stats.codahale.CodahaleMetricsProvider;
import org.apache.bookkeeper.stats.codahale.FastCodahaleMetricsProvider;
import org.apache.bookkeeper.stats.prometheus.PrometheusMetricsProvider;
import org.apache.bookkeeper.stats.twitter.ostrich.OstrichProvider;
import org.apache.bookkeeper.stats.twitter.science.TwitterStatsProvider;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Threads(value=16)
@Fork(value=1)
@Warmup(iterations=1, time=10, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=3, time=10, timeUnit=TimeUnit.SECONDS)
public class StatsLoggerBenchmark {
    private static Map<String, Supplier<StatsProvider>> providers = new HashMap<String, Supplier<StatsProvider>>();

    @Benchmark
    public void counterIncrement(LoggerState s) {
        s.counter.inc();
    }

    @Benchmark
    public void recordLatency(LoggerState s) {
        s.opStats.registerSuccessfulValue(System.nanoTime() - s.startTime);
    }

    static {
        providers.put("Prometheus", PrometheusMetricsProvider::new);
        providers.put("Codahale", CodahaleMetricsProvider::new);
        providers.put("FastCodahale", FastCodahaleMetricsProvider::new);
        providers.put("Twitter", TwitterStatsProvider::new);
        providers.put("Ostrich", OstrichProvider::new);
    }

    @State(value=Scope.Benchmark)
    public static class LoggerState {
        @Param(value={"Prometheus", "Codahale", "FastCodahale", "Twitter", "Ostrich"})
        private String statsProvider;
        private Counter counter;
        private OpStatsLogger opStats;
        private long startTime = System.nanoTime();

        @Setup(value=Level.Trial)
        public void setup() {
            StatsProvider provider = (StatsProvider)((Supplier)providers.get(this.statsProvider)).get();
            StatsLogger logger = provider.getStatsLogger("test");
            this.counter = logger.getCounter("counter");
            this.opStats = logger.getOpStatsLogger("opstats");
        }
    }
}

