/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.stats.codahale;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.stats.codahale.CodahaleMetricsProvider;
import org.apache.bookkeeper.stats.codahale.FastCodahaleMetricsProvider;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

public class TimerBenchmark {
    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    @Warmup(iterations=2, time=3, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=2, time=10, timeUnit=TimeUnit.SECONDS)
    @Threads(value=4)
    @Fork(value=1, warmups=1)
    public void timerTest(MyState state) {
        state.getTimer().registerSuccessfulEvent(state.getTime(), TimeUnit.MILLISECONDS);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    @OutputTimeUnit(value=TimeUnit.MILLISECONDS)
    @Warmup(iterations=2, time=3, timeUnit=TimeUnit.SECONDS)
    @Measurement(iterations=2, time=10, timeUnit=TimeUnit.SECONDS)
    @Threads(value=4)
    @Fork(value=1, warmups=1)
    public void timerTestWithSnapshots(MyState state) {
        OpStatsLogger timer = state.getTimer();
        if (state.isGetSnapshot()) {
            timer.toOpStatsData();
        } else {
            timer.registerSuccessfulEvent(state.getTime(), TimeUnit.MILLISECONDS);
        }
    }

    public static void main(String[] args) {
        int i;
        if (args.length != 1 || !args[0].equalsIgnoreCase("codahale") && !args[0].equalsIgnoreCase("fast")) {
            System.out.println("usage: " + TimerBenchmark.class.getCanonicalName() + " <codahale|fast>");
            System.exit(1);
        }
        StatsLogger logger = null;
        logger = args[0].equalsIgnoreCase("codahale") ? new CodahaleMetricsProvider().getStatsLogger("test") : new FastCodahaleMetricsProvider().getStatsLogger("test");
        System.out.println("Using " + logger.getClass().getCanonicalName());
        System.out.println("Creating 1000 OpStatsLoggers (2000 Timers) and updating each of them 1000 times ...");
        OpStatsLogger[] timers = new OpStatsLogger[1000];
        for (int i2 = 0; i2 < timers.length; ++i2) {
            timers[i2] = logger.getOpStatsLogger("test-timer-" + i2);
        }
        long[] times = new long[199];
        for (i = 0; i < times.length; ++i) {
            times[i] = Math.abs(ThreadLocalRandom.current().nextLong() % 1000L);
        }
        for (i = 0; i < 1000 * timers.length; ++i) {
            timers[i % timers.length].registerSuccessfulEvent(times[i % times.length], TimeUnit.MILLISECONDS);
            timers[i % timers.length].registerFailedEvent(times[i % times.length], TimeUnit.MILLISECONDS);
        }
        times = null;
        System.out.println("Done.");
        System.out.println("Now run 'jmap -histo:live <pid>' on this JVM to get a heap histogram, then kill this JVM.");
        while (true) {
            try {
                while (true) {
                    TimeUnit.MILLISECONDS.sleep(1000L);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    @State(value=Scope.Thread)
    public static class MyState {
        @Param
        public TimerType timerType;
        @Param(value={"1", "10", "100"})
        public int timersPerThread;
        private static OpStatsLogger[] timers;
        private int timerIdx = 0;
        private static long[] times;
        private int timeIdx = 0;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Setup(value=Level.Trial)
        public void doSetup() throws Exception {
            StatsLogger logger = null;
            switch (this.timerType) {
                case CodahaleTimer: {
                    logger = new CodahaleMetricsProvider().getStatsLogger("test");
                    break;
                }
                case FastTimer: {
                    logger = new FastCodahaleMetricsProvider().getStatsLogger("test");
                }
            }
            Class<MyState> clazz = MyState.class;
            synchronized (MyState.class) {
                if (timers == null) {
                    int i;
                    timers = new OpStatsLogger[this.timersPerThread];
                    for (i = 0; i < this.timersPerThread; ++i) {
                        MyState.timers[i] = logger.getOpStatsLogger("test-timer-" + i);
                    }
                    times = new long[1000];
                    for (i = 0; i < times.length; ++i) {
                        MyState.times[i] = Math.abs(ThreadLocalRandom.current().nextLong() % 1000L);
                    }
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public OpStatsLogger getTimer() {
            return timers[this.timerIdx++ % timers.length];
        }

        public long getTime() {
            return times[this.timeIdx++ % times.length];
        }

        public boolean isGetSnapshot() {
            if (this.timeIdx % 109 == 0) {
                ++this.timeIdx;
                return true;
            }
            return false;
        }
    }

    public static enum TimerType {
        CodahaleTimer,
        FastTimer;

    }
}

