/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.base.Charsets;
import com.google.protobuf.ByteString;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.proto.BookieProtoEncoding;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.PerChannelBookieClient;
import org.apache.bookkeeper.util.ByteBufList;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.slf4j.MDC;

@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.MILLISECONDS)
@State(value=Scope.Thread)
public class ProtocolBenchmark {
    @Param(value={"10", "100", "1000", "10000"})
    int size;
    byte[] masterKey;
    ByteBuf entry;
    long ledgerId;
    long entryId;
    short flags;
    BookieProtoEncoding.EnDecoder reqEnDeV2;
    BookieProtoEncoding.EnDecoder reqEnDeV3;

    @Setup
    public void prepare() {
        this.masterKey = "test-benchmark-key".getBytes(Charsets.UTF_8);
        Random r = new Random(System.currentTimeMillis());
        byte[] data = new byte[this.size];
        r.nextBytes(data);
        this.entry = Unpooled.wrappedBuffer((byte[])data);
        this.ledgerId = r.nextLong();
        this.entryId = r.nextLong();
        this.flags = 1;
        this.reqEnDeV2 = new BookieProtoEncoding.RequestEnDeCoderPreV3(null);
        this.reqEnDeV3 = new BookieProtoEncoding.RequestEnDecoderV3(null);
    }

    @Benchmark
    public void testAddEntryV2() throws Exception {
        ByteBufList list = ByteBufList.get((ByteBuf)this.entry.retainedSlice());
        BookieProtocol.AddRequest req = BookieProtocol.AddRequest.create((byte)2, (long)this.ledgerId, (long)this.entryId, (short)this.flags, (byte[])this.masterKey, (ByteBufList)list);
        Object res = this.reqEnDeV2.encode((Object)req, ByteBufAllocator.DEFAULT);
        ReferenceCountUtil.release((Object)res);
        ReferenceCountUtil.release((Object)list);
    }

    @Benchmark
    public void testAddEntryV3() throws Exception {
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.ADD_ENTRY).setTxnId(0L);
        ByteBuf toSend = this.entry.slice();
        byte[] toSendArray = new byte[toSend.readableBytes()];
        toSend.getBytes(toSend.readerIndex(), toSendArray);
        BookkeeperProtocol.AddRequest.Builder addBuilder = BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(this.ledgerId).setEntryId(this.entryId).setMasterKey(ByteString.copyFrom((byte[])this.masterKey)).setBody(ByteString.copyFrom((byte[])toSendArray)).setFlag(BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD);
        BookkeeperProtocol.Request request = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setAddRequest(addBuilder).build();
        Object res = this.reqEnDeV3.encode((Object)request, ByteBufAllocator.DEFAULT);
        ReferenceCountUtil.release((Object)res);
    }

    @Benchmark
    public void testAddEntryV3WithMdc() throws Exception {
        MDC.put((String)"parent_id", (String)"LetsPutSomeLongParentRequestIdHere");
        MDC.put((String)"request_id", (String)"LetsPutSomeLongRequestIdHere");
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.ADD_ENTRY).setTxnId(0L);
        ByteBuf toSend = this.entry.slice();
        byte[] toSendArray = new byte[toSend.readableBytes()];
        toSend.getBytes(toSend.readerIndex(), toSendArray);
        BookkeeperProtocol.AddRequest.Builder addBuilder = BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(this.ledgerId).setEntryId(this.entryId).setMasterKey(ByteString.copyFrom((byte[])this.masterKey)).setBody(ByteString.copyFrom((byte[])toSendArray)).setFlag(BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD);
        BookkeeperProtocol.Request request = PerChannelBookieClient.appendRequestContext((BookkeeperProtocol.Request.Builder)BookkeeperProtocol.Request.newBuilder()).setHeader(headerBuilder).setAddRequest(addBuilder).build();
        Object res = this.reqEnDeV3.encode((Object)request, ByteBufAllocator.DEFAULT);
        ReferenceCountUtil.release((Object)res);
        MDC.clear();
    }

    static BookkeeperProtocol.Request.Builder appendRequestContextNoMdc(BookkeeperProtocol.Request.Builder builder) {
        BookkeeperProtocol.ContextPair context1 = BookkeeperProtocol.ContextPair.newBuilder().setKey("parent_id").setValue("LetsPutSomeLongParentRequestIdHere").build();
        builder.addRequestContext(context1);
        BookkeeperProtocol.ContextPair context2 = BookkeeperProtocol.ContextPair.newBuilder().setKey("request_id").setValue("LetsPutSomeLongRequestIdHere").build();
        builder.addRequestContext(context2);
        return builder;
    }

    @Benchmark
    public void testAddEntryV3WithExtraContextDataNoMdc() throws Exception {
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.ADD_ENTRY).setTxnId(0L);
        ByteBuf toSend = this.entry.slice();
        byte[] toSendArray = new byte[toSend.readableBytes()];
        toSend.getBytes(toSend.readerIndex(), toSendArray);
        BookkeeperProtocol.AddRequest.Builder addBuilder = BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(this.ledgerId).setEntryId(this.entryId).setMasterKey(ByteString.copyFrom((byte[])this.masterKey)).setBody(ByteString.copyFrom((byte[])toSendArray)).setFlag(BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD);
        BookkeeperProtocol.Request request = ProtocolBenchmark.appendRequestContextNoMdc(BookkeeperProtocol.Request.newBuilder()).setHeader(headerBuilder).setAddRequest(addBuilder).build();
        Object res = this.reqEnDeV3.encode((Object)request, ByteBufAllocator.DEFAULT);
        ReferenceCountUtil.release((Object)res);
    }
}

