/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.dlog;

import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.tools.common.BKCommand;
import org.apache.bookkeeper.tools.common.BKFlags;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.framework.CliSpec;
import org.apache.bookkeeper.tools.perf.dlog.PerfReaderBase;
import org.apache.bookkeeper.tools.perf.dlog.PerfSegmentReader;
import org.apache.commons.configuration.CompositeConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentReadCommand
extends BKCommand<PerfReaderBase.Flags> {
    private static final Logger log = LoggerFactory.getLogger(SegmentReadCommand.class);
    private static final String NAME = "segread";
    private static final String DESC = "Read log records from distributedlog streams by breaking it down to segments";

    public SegmentReadCommand() {
        super(CliSpec.newBuilder().withName(NAME).withDescription(DESC).withFlags((CliFlags)new PerfReaderBase.Flags()).build());
    }

    protected boolean apply(ServiceURI serviceURI, CompositeConfiguration conf, BKFlags globalFlags, PerfReaderBase.Flags cmdFlags) {
        if (serviceURI == null) {
            log.warn("No service uri is provided. Use default 'distributedlog://localhost/distributedlog'.");
            serviceURI = ServiceURI.create((String)"distributedlog://localhost/distributedlog");
        }
        PerfSegmentReader reader = new PerfSegmentReader(serviceURI, cmdFlags);
        reader.run();
        return true;
    }
}

