/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.perf.table;

import com.beust.jcommander.Parameter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.util.concurrent.RateLimiter;
import io.netty.buffer.ByteBuf;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.HdrHistogram.Histogram;
import org.HdrHistogram.Recorder;
import org.apache.bookkeeper.api.StorageClient;
import org.apache.bookkeeper.api.kv.Table;
import org.apache.bookkeeper.clients.StorageClientBuilder;
import org.apache.bookkeeper.clients.config.StorageClientSettings;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.common.net.ServiceURI;
import org.apache.bookkeeper.tools.framework.CliFlags;
import org.apache.bookkeeper.tools.perf.table.BenchmarkTask;
import org.apache.bookkeeper.tools.perf.table.IncrementRandomTask;
import org.apache.bookkeeper.tools.perf.table.IncrementSequentialTask;
import org.apache.bookkeeper.tools.perf.table.KeyGenerator;
import org.apache.bookkeeper.tools.perf.table.WriteRandomTask;
import org.apache.bookkeeper.tools.perf.table.WriteSequentialTask;
import org.apache.bookkeeper.tools.perf.utils.PaddingDecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerfClient
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(PerfClient.class);
    private final ServiceURI serviceURI;
    private final Flags flags;
    private static final DecimalFormat throughputFormat = new PaddingDecimalFormat("0.0", 8);
    private static final DecimalFormat dec = new PaddingDecimalFormat("0.000", 7);

    PerfClient(ServiceURI serviceURI, Flags flags) {
        this.serviceURI = serviceURI;
        this.flags = flags;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            log.error("Encountered exception at running table perf client", (Throwable)e);
        }
    }

    void execute() throws Exception {
        ObjectMapper m = new ObjectMapper();
        ObjectWriter w = m.writerWithDefaultPrettyPrinter();
        log.info("Starting table perf client with config : {}", (Object)w.writeValueAsString((Object)this.flags));
        this.runBenchmarkTasks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBenchmarkTasks() throws Exception {
        StorageClientSettings settings = StorageClientSettings.newBuilder().serviceUri(this.serviceURI.getUri().toString()).build();
        try (StorageClient client = StorageClientBuilder.newBuilder().withSettings(settings).withNamespace(this.flags.namespace).build();
             Table table = (Table)FutureUtils.result((CompletableFuture)client.openTable(this.flags.tableName));){
            long randSeed = System.currentTimeMillis();
            KeyGenerator generator = new KeyGenerator(this.flags.numKeys, this.flags.keysPerPrefix, this.flags.prefixSize);
            RateLimiter limiter = this.flags.rate <= 0 ? null : RateLimiter.create((double)this.flags.rate);
            for (String benchmark : this.flags.benchmarks) {
                ArrayList<BenchmarkTask> tasks = new ArrayList<BenchmarkTask>();
                int currentTaskId = 0;
                Semaphore semaphore = this.flags.maxOutstandingRequests <= 0 ? null : new Semaphore(this.flags.maxOutstandingRequests);
                switch (benchmark) {
                    case "fillseq": {
                        tasks.add(new WriteSequentialTask((Table<ByteBuf, ByteBuf>)table, currentTaskId++, randSeed, Math.max(this.flags.numOps, this.flags.numKeys), this.flags.numKeys, this.flags, generator, limiter, semaphore));
                        break;
                    }
                    case "fillrandom": {
                        tasks.add(new WriteRandomTask((Table<ByteBuf, ByteBuf>)table, currentTaskId++, randSeed, Math.max(this.flags.numOps, this.flags.numKeys), this.flags.numKeys, this.flags, generator, limiter, semaphore));
                        break;
                    }
                    case "incseq": {
                        tasks.add(new IncrementSequentialTask((Table<ByteBuf, ByteBuf>)table, currentTaskId++, randSeed, Math.max(this.flags.numOps, this.flags.numKeys), this.flags.numKeys, this.flags, generator, limiter, semaphore));
                        break;
                    }
                    case "incrandom": {
                        tasks.add(new IncrementRandomTask((Table<ByteBuf, ByteBuf>)table, currentTaskId++, randSeed, Math.max(this.flags.numOps, this.flags.numKeys), this.flags.numKeys, this.flags, generator, limiter, semaphore));
                        break;
                    }
                    default: {
                        System.err.println("Unknown benchmark: " + benchmark);
                    }
                }
                if (tasks.isEmpty()) continue;
                CountDownLatch latch = new CountDownLatch(tasks.size());
                ExecutorService executor = Executors.newCachedThreadPool();
                try {
                    for (BenchmarkTask task2 : tasks) {
                        executor.submit(() -> {
                            try {
                                task2.runTask();
                            }
                            catch (Exception e) {
                                log.error("Encountered issue at running benchmark task {}", (Object)task.tid, (Object)e);
                            }
                            finally {
                                latch.countDown();
                            }
                        });
                    }
                    ExecutorService statsExecutor = Executors.newSingleThreadExecutor();
                    try {
                        statsExecutor.submit(() -> this.reportStats(tasks));
                        latch.await();
                        log.info("------------------- DONE -----------------------");
                        tasks.forEach(task -> task.printAggregatedStats());
                    }
                    finally {
                        if (Collections.singletonList(statsExecutor).get(0) == null) continue;
                        statsExecutor.shutdown();
                    }
                }
                finally {
                    if (Collections.singletonList(executor).get(0) == null) continue;
                    executor.shutdown();
                }
            }
        }
    }

    private void reportStats(List<BenchmarkTask> tasks) {
        long oldTime = System.nanoTime();
        while (true) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                break;
            }
            long startTime = oldTime;
            tasks.forEach(task -> task.reportStats(startTime));
            oldTime = System.nanoTime();
        }
    }

    static class OpStats {
        private final String name;
        private final LongAdder ops = new LongAdder();
        private final Recorder recorder = new Recorder(TimeUnit.SECONDS.toMillis(120000L), 5);
        private final Recorder cumulativeRecorder = new Recorder(TimeUnit.SECONDS.toMillis(120000L), 5);
        private Histogram reportHistogram;

        OpStats(String name) {
            this.name = name;
        }

        void recordOp(long latencyMicros) {
            this.ops.increment();
            this.recorder.recordValue(latencyMicros);
            this.cumulativeRecorder.recordValue(latencyMicros);
        }

        void reportStats(long oldTime) {
            long now = System.nanoTime();
            double elapsed = (double)(now - oldTime) / 1.0E9;
            double rate = (double)this.ops.sumThenReset() / elapsed;
            this.reportHistogram = this.recorder.getIntervalHistogram(this.reportHistogram);
            log.info("[{}] Throughput: {}  ops/s --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - Max: {}", new Object[]{this.name, throughputFormat.format(rate), dec.format(this.reportHistogram.getMean() / 1000.0), dec.format((double)this.reportHistogram.getValueAtPercentile(50.0) / 1000.0), dec.format((double)this.reportHistogram.getValueAtPercentile(95.0) / 1000.0), dec.format((double)this.reportHistogram.getValueAtPercentile(99.0) / 1000.0), dec.format((double)this.reportHistogram.getValueAtPercentile(99.9) / 1000.0), dec.format((double)this.reportHistogram.getValueAtPercentile(99.99) / 1000.0), dec.format((double)this.reportHistogram.getMaxValue() / 1000.0)});
            this.reportHistogram.reset();
        }

        void printAggregatedStats() {
            Histogram reportHistogram = this.cumulativeRecorder.getIntervalHistogram();
            log.info("[{}] latency stats --- Latency: mean: {} ms - med: {} - 95pct: {} - 99pct: {} - 99.9pct: {} - 99.99pct: {} - 99.999pct: {} - Max: {}", new Object[]{this.name, dec.format(reportHistogram.getMean() / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(50.0) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(95.0) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.0) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.9) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.99) / 1000.0), dec.format((double)reportHistogram.getValueAtPercentile(99.999) / 1000.0), dec.format((double)reportHistogram.getMaxValue() / 1000.0)});
        }
    }

    public static class Flags
    extends CliFlags {
        @Parameter(names={"-r", "--rate"}, description="Request rate - requests/second")
        public int rate = 100000;
        @Parameter(names={"-mor", "--max-outstanding-requests"}, description="Max outstanding request")
        public int maxOutstandingRequests = 10000;
        @Parameter(names={"-ks", "--key-size"}, description="Key size")
        public int keySize = 16;
        @Parameter(names={"-vs", "--value-size"}, description="Value size")
        public int valueSize = 100;
        @Parameter(names={"-t", "--table-name"}, description="Table name")
        public String tableName = "test-table";
        @Parameter(names={"-nk", "--num-keys"}, description="Number of the keys to test")
        public int numKeys = 1000000;
        @Parameter(names={"-kpp", "--keys-per-prefix"}, description="control average number of keys generated per prefix, 0 means no special handling of the prefix, i.e. use the prefix comes with the generated random number")
        public int keysPerPrefix = 0;
        @Parameter(names={"-ps", "--prefix-size"}, description="Prefix size")
        public int prefixSize = 0;
        @Parameter(names={"-no", "--num-ops"}, description="Number of client operations to test")
        public int numOps = 0;
        @Parameter(names={"-ns", "--namespace"}, description="Namespace of the tables to benchmark")
        public String namespace = "benchmark";
        @Parameter(names={"-b", "--benchmarks"}, description="List of benchamrks to run")
        public List<String> benchmarks;
    }

    static enum OP {
        PUT,
        GET,
        INC,
        DEL;

    }
}

