/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.benchmark;

import com.google.common.base.Charsets;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClient {
    private static final Logger LOG = LoggerFactory.getLogger(TestClient.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ParseException {
        Options options = new Options();
        options.addOption("length", true, "Length of packets being written. Default 1024");
        options.addOption("target", true, "Target medium to write to. Options are bk, fs & hdfs. Default fs");
        options.addOption("runfor", true, "Number of seconds to run for. Default 60");
        options.addOption("path", true, "Path to write to. fs & hdfs only. Default /foobar");
        options.addOption("zkservers", true, "ZooKeeper servers, comma separated. bk only. Default localhost:2181.");
        options.addOption("bkensemble", true, "BookKeeper ledger ensemble size. bk only. Default 3");
        options.addOption("bkquorum", true, "BookKeeper ledger quorum size. bk only. Default 2");
        options.addOption("bkthrottle", true, "BookKeeper throttle size. bk only. Default 10000");
        options.addOption("sync", false, "Use synchronous writes with BookKeeper. bk only.");
        options.addOption("numconcurrent", true, "Number of concurrently clients. Default 1");
        options.addOption("timeout", true, "Number of seconds after which to give up");
        options.addOption("help", false, "This message");
        PosixParser parser = new PosixParser();
        CommandLine cmd = parser.parse(options, args);
        if (cmd.hasOption("help")) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp("TestClient <options>", options);
            System.exit(-1);
        }
        int length = Integer.parseInt(cmd.getOptionValue("length", "1024"));
        String target = cmd.getOptionValue("target", "fs");
        long runfor = Long.parseLong(cmd.getOptionValue("runfor", "60")) * 1000L;
        StringBuilder sb = new StringBuilder();
        while (length-- > 0) {
            sb.append('a');
        }
        Timer timeouter = new Timer();
        if (cmd.hasOption("timeout")) {
            final long timeout = Long.parseLong(cmd.getOptionValue("timeout", "360")) * 1000L;
            timeouter.schedule(new TimerTask(){

                @Override
                public void run() {
                    System.err.println("Timing out benchmark after " + timeout + "ms");
                    System.exit(-1);
                }
            }, timeout);
        }
        BookKeeper bkc = null;
        try {
            int numFiles = Integer.parseInt(cmd.getOptionValue("numconcurrent", "1"));
            int numThreads = Math.min(numFiles, 1000);
            byte[] data = sb.toString().getBytes(Charsets.UTF_8);
            long runid = System.currentTimeMillis();
            ArrayList<Callable<Long>> clients = new ArrayList<Callable<Long>>();
            if (target.equals("bk")) {
                int i;
                String zkservers = cmd.getOptionValue("zkservers", "localhost:2181");
                int bkensemble = Integer.parseInt(cmd.getOptionValue("bkensemble", "3"));
                int bkquorum = Integer.parseInt(cmd.getOptionValue("bkquorum", "2"));
                int bkthrottle = Integer.parseInt(cmd.getOptionValue("bkthrottle", "10000"));
                ClientConfiguration conf = new ClientConfiguration();
                conf.setThrottleValue(bkthrottle);
                conf.setMetadataServiceUri("zk://" + zkservers + "/ledgers");
                bkc = new BookKeeper(conf);
                ArrayList<LedgerHandle> handles = new ArrayList<LedgerHandle>();
                for (i = 0; i < numFiles; ++i) {
                    handles.add(bkc.createLedger(bkensemble, bkquorum, BookKeeper.DigestType.CRC32, new byte[]{97, 98}));
                }
                for (i = 0; i < numFiles; ++i) {
                    clients.add(new BKClient(handles, data, runfor, cmd.hasOption("sync")));
                }
            } else if (target.equals("fs")) {
                int i;
                ArrayList<FileOutputStream> streams = new ArrayList<FileOutputStream>();
                for (i = 0; i < numFiles; ++i) {
                    String path = cmd.getOptionValue("path", "/foobar " + i);
                    streams.add(new FileOutputStream(path + runid + "_" + i));
                }
                for (i = 0; i < numThreads; ++i) {
                    clients.add(new FileClient(streams, data, runfor));
                }
            } else {
                LOG.error("Unknown option: " + target);
                throw new IllegalArgumentException("Unknown target " + target);
            }
            ExecutorService executor = Executors.newFixedThreadPool(numThreads);
            long start = System.currentTimeMillis();
            List results = executor.invokeAll(clients, 10L, TimeUnit.MINUTES);
            long end = System.currentTimeMillis();
            long count = 0L;
            for (Future r : results) {
                long c;
                if (!r.isDone()) {
                    LOG.warn("Job didn't complete");
                    System.exit(2);
                }
                if ((c = ((Long)r.get()).longValue()) == 0L) {
                    LOG.warn("Task didn't complete");
                }
                count += c;
            }
            long time = end - start;
            LOG.info("Finished processing writes (ms): {} TPT: {} op/s", (Object)time, (Object)((double)count / ((double)time / 1000.0)));
            executor.shutdown();
        }
        catch (ExecutionException ee) {
            LOG.error("Exception in worker", (Throwable)ee);
        }
        catch (BKException e) {
            LOG.error("Error accessing bookkeeper", (Throwable)e);
        }
        catch (IOException ioe) {
            LOG.error("I/O exception during benchmark", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            LOG.error("Benchmark interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        finally {
            if (bkc != null) {
                try {
                    bkc.close();
                }
                catch (BKException bke) {
                    LOG.error("Error closing bookkeeper client", (Throwable)bke);
                }
                catch (InterruptedException ie) {
                    LOG.warn("Interrupted closing bookkeeper client", (Throwable)ie);
                    Thread.currentThread().interrupt();
                }
            }
        }
        timeouter.cancel();
    }

    static class BKClient
    implements Callable<Long>,
    AsyncCallback.AddCallback {
        final List<LedgerHandle> handles;
        final byte[] data;
        final long time;
        final Random r;
        final boolean sync;
        final AtomicLong success = new AtomicLong(0L);
        final AtomicLong outstanding = new AtomicLong(0L);

        BKClient(List<LedgerHandle> handles, byte[] data, long time, boolean sync) {
            this.handles = handles;
            this.data = data;
            this.time = time;
            this.r = new Random(System.identityHashCode(this));
            this.sync = sync;
        }

        @Override
        public Long call() {
            try {
                long start = System.currentTimeMillis();
                long stopat = start + this.time;
                while (System.currentTimeMillis() < stopat) {
                    LedgerHandle lh = this.handles.get(this.r.nextInt(this.handles.size()));
                    if (this.sync) {
                        lh.addEntry(this.data);
                        this.success.incrementAndGet();
                        continue;
                    }
                    lh.asyncAddEntry(this.data, (AsyncCallback.AddCallback)this, null);
                    this.outstanding.incrementAndGet();
                }
                int ticks = 10;
                while (this.outstanding.get() > 0L && ticks-- > 0) {
                    Thread.sleep(10L);
                }
                long time = System.currentTimeMillis() - start;
                LOG.info("Worker finished processing writes (ms): {} TPT: {} op/s", (Object)time, (Object)((double)this.success.get() / ((double)time / 1000.0)));
                return this.success.get();
            }
            catch (BKException e) {
                LOG.error("Exception in worker thread", (Throwable)e);
                return 0L;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.error("Exception in worker thread", (Throwable)ie);
                return 0L;
            }
        }

        public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
            if (rc == 0) {
                this.success.incrementAndGet();
            }
            this.outstanding.decrementAndGet();
        }
    }

    static class FileClient
    implements Callable<Long> {
        final List<FileOutputStream> streams;
        final byte[] data;
        final long time;
        final Random r;

        FileClient(List<FileOutputStream> streams, byte[] data, long time) {
            this.streams = streams;
            this.data = data;
            this.time = time;
            this.r = new Random(System.identityHashCode(this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Long call() {
            try {
                long count = 0L;
                long start = System.currentTimeMillis();
                long stopat = start + this.time;
                while (System.currentTimeMillis() < stopat) {
                    FileOutputStream stream;
                    FileOutputStream fileOutputStream = stream = this.streams.get(this.r.nextInt(this.streams.size()));
                    synchronized (fileOutputStream) {
                        stream.write(this.data);
                        stream.flush();
                        stream.getChannel().force(false);
                    }
                    ++count;
                }
                long time = System.currentTimeMillis() - start;
                LOG.info("Worker finished processing writes (ms): {} TPT: {} op/s", (Object)time, (Object)((double)count / ((double)time / 1000.0)));
                return count;
            }
            catch (IOException ioe) {
                LOG.error("Exception in worker thread", (Throwable)ioe);
                return 0L;
            }
        }
    }
}

