/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.benchmark;

import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlClient {
    static Logger LOG = LoggerFactory.getLogger(MySqlClient.class);
    BookKeeper x;
    LedgerHandle lh;
    Integer entryId = 0;
    HashMap<Integer, Integer> map = new HashMap();
    FileOutputStream fStream;
    FileOutputStream fStreamLocal;
    long start;
    long lastId;
    Connection con;
    Statement stmt;

    public MySqlClient(String hostport, String user, String pass) throws ClassNotFoundException {
        Class.forName("com.mysql.jdbc.Driver");
        String url = "jdbc:mysql://" + hostport + "/bookkeeper";
        try {
            this.con = DriverManager.getConnection(url, user, pass);
            this.stmt = this.con.createStatement();
            this.stmt.execute("DROP TABLE IF EXISTS data;");
            this.stmt.execute("create table data(transaction_id bigint PRIMARY KEY AUTO_INCREMENT, content TEXT);");
            LOG.info("Database initialization terminated");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public void closeHandle() throws KeeperException, InterruptedException, SQLException {
        this.con.close();
    }

    public static void main(String[] args) throws ClassNotFoundException, SQLException {
        int lenght = Integer.parseInt(args[1]);
        StringBuilder sb = new StringBuilder();
        while (lenght-- > 0) {
            sb.append('a');
        }
        try {
            MySqlClient c = new MySqlClient(args[2], args[3], args[4]);
            c.writeSameEntryBatch(sb.toString().getBytes(), Integer.parseInt(args[0]));
            c.writeSameEntry(sb.toString().getBytes(), Integer.parseInt(args[0]));
            c.closeHandle();
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (KeeperException e) {
            e.printStackTrace();
        }
    }

    void writeSameEntryBatch(byte[] data, int times) throws InterruptedException, SQLException {
        this.start = System.currentTimeMillis();
        int count = times;
        String content = new String(data);
        System.out.println("Data: " + content + ", " + data.length);
        while (count-- > 0) {
            this.stmt.addBatch("insert into data(content) values(\"" + content + "\");");
        }
        LOG.info("Finished writing batch SQL command in ms: " + (System.currentTimeMillis() - this.start));
        this.start = System.currentTimeMillis();
        this.stmt.executeBatch();
        System.out.println("Finished " + times + " writes in ms: " + (System.currentTimeMillis() - this.start));
        LOG.info("Ended computation");
    }

    void writeSameEntry(byte[] data, int times) throws InterruptedException, SQLException {
        this.start = System.currentTimeMillis();
        int count = times;
        String content = new String(data);
        System.out.println("Data: " + content + ", " + data.length);
        while (count-- > 0) {
            this.stmt.executeUpdate("insert into data(content) values(\"" + content + "\");");
        }
        System.out.println("Finished " + times + " writes in ms: " + (System.currentTimeMillis() - this.start));
        LOG.info("Ended computation");
    }
}

