/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bigtop.itest;

import org.apache.bigtop.itest.Contract;
import org.apache.bigtop.itest.ParameterSetter;
import org.apache.bigtop.itest.Property;
import org.apache.bigtop.itest.Variable;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@Contract(properties={@Property(name="foo.int1", type=Property.Type.INT, intValue=1000), @Property(name="foo.int2", type=Property.Type.INT), @Property(name="foo.bar1", type=Property.Type.STRING, defaultValue="xyz"), @Property(name="foo.bar2", type=Property.Type.STRING), @Property(name="foo.bool1", type=Property.Type.BOOLEAN), @Property(name="foo.bool2", type=Property.Type.BOOLEAN)}, env={@Variable(name="HOME"), @Variable(name="BIGTOP_UNLIKELY_FOO_ENV", required=false)})
public class TestContractJavaProc {
    public static int foo_int1;
    public static int foo_int2;
    protected static String foo_bar1;
    protected static String foo_bar2;
    private static boolean foo_bool1;
    private static boolean foo_bool2;
    static String HOME;
    static String BIGTOP_UNLIKELY_FOO_ENV;

    @BeforeClass
    public static void setUp() throws ClassNotFoundException, InterruptedException, NoSuchFieldException, IllegalAccessException {
        System.setProperty("foo.int2", "100");
        System.setProperty("foo.bool2", "true");
        ParameterSetter.setProperties(TestContractJavaProc.class, (String[])new String[]{"foo_int1", "foo_int2", "foo_bar1", "foo_bar2", "foo_bool1", "foo_bool2"});
        ParameterSetter.setEnv(TestContractJavaProc.class, (String[])new String[]{"HOME", "BIGTOP_UNLIKELY_FOO_ENV"});
    }

    @Test
    public void testPropSettings() {
        Assert.assertEquals((String)"checking the value of foo_int1 from default value", (long)1000L, (long)foo_int1);
        Assert.assertEquals((String)"checking the value of foo_int2 from foo.int2", (long)100L, (long)foo_int2);
        Assert.assertEquals((String)"checking the value of foo_bar1 from default value", (Object)"xyz", (Object)foo_bar1);
        Assert.assertEquals((String)"checking the value of foo_bar2 from unset value", (Object)"", (Object)foo_bar2);
        Assert.assertEquals((String)"checking the value of foo_bool1 from unset value", (Object)false, (Object)foo_bool1);
        Assert.assertEquals((String)"checking the value of foo_bar2 from foo.bool2", (Object)true, (Object)foo_bool2);
    }

    @Test
    public void testEnvSettings() {
        Assert.assertEquals((String)"checking the value of $HOME", (Object)System.getenv("HOME"), (Object)HOME);
        Assert.assertEquals((String)"checking the value of $BIGTOP_UNLIKELY_FOO_ENV", null, (Object)BIGTOP_UNLIKELY_FOO_ENV);
    }
}

