/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bigtop.itest.hivesmoke;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import org.apache.bigtop.itest.Contract;
import org.apache.bigtop.itest.ParameterSetter;
import org.apache.bigtop.itest.Property;
import org.apache.bigtop.itest.shell.Shell;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

@Contract(properties={@Property(name="hiveserver.startup.wait", type=Property.Type.INT, longValue=3000L, intValue=3000, defaultValue="3000")}, env={})
public class TestJdbcDriver {
    public static String driverName = "org.apache.hadoop.hive.jdbc.HiveDriver";
    public static String hiveserver_url = "jdbc:hive://localhost:10000/default";
    public static Shell sh = new Shell("/bin/bash -s");
    public static String testDir = "/tmp/hive-jdbc." + new Date().getTime();
    public static String hiveserver_pid;
    public static int hiveserver_startup_wait;
    private Connection con;

    @BeforeClass
    public static void setUp() throws ClassNotFoundException, InterruptedException, NoSuchFieldException, IllegalAccessException {
        ParameterSetter.setProperties(TestJdbcDriver.class, (String[])new String[]{"hiveserver_startup_wait"});
        System.out.println("hiveserver_startup_wait: " + hiveserver_startup_wait);
        Class.forName(driverName);
        sh.exec(new Object[]{"hadoop fs -mkdir " + testDir});
        Assert.assertTrue((String)"Could not create test directory", (sh.getRet() == 0 ? 1 : 0) != 0);
        sh.exec(new Object[]{"hadoop fs -copyFromLocal a.txt " + testDir + "/a.txt"});
        Assert.assertTrue((String)"Could not copy local file to test directory", (sh.getRet() == 0 ? 1 : 0) != 0);
        sh.exec(new Object[]{"(HIVE_PORT=10000 hive --service hiveserver > /dev/null 2>&1 & echo $! ) 2> /dev/null"});
        hiveserver_pid = (String)sh.getOut().get(0);
        Thread.sleep(hiveserver_startup_wait);
    }

    @Before
    public void getConnection() throws SQLException {
        this.con = DriverManager.getConnection(hiveserver_url, "", "");
    }

    @After
    public void closeConnection() throws SQLException {
        if (this.con != null) {
            this.con.close();
        }
    }

    @AfterClass
    public static void tearDown() {
        sh.exec(new Object[]{"hadoop fs -rmr -skipTrash " + testDir});
        sh.exec(new Object[]{"kill -9 " + hiveserver_pid});
    }

    @Test(timeout=120000L)
    public void testCreate() throws SQLException {
        Statement stmt = this.con.createStatement();
        String tableName = "hive_jdbc_driver_test";
        stmt.executeQuery("drop table if exists " + tableName);
        ResultSet res = stmt.executeQuery("create table " + tableName + " (key int, value string)");
        String sql = "show tables";
        res = stmt.executeQuery(sql);
        boolean tableCreated = false;
        while (res.next()) {
            String tab_name = res.getString(1);
            if (!tab_name.equals(tableName)) continue;
            tableCreated = true;
        }
        Assert.assertTrue((String)("table " + tableName + " does not appear to be created"), (boolean)tableCreated);
        sql = "describe " + tableName;
        res = stmt.executeQuery(sql);
        ArrayList<String> colNames = new ArrayList<String>();
        ArrayList<String> dataTypes = new ArrayList<String>();
        while (res.next()) {
            String col_name = res.getString(1);
            String data_type = res.getString(2);
            colNames.add(col_name);
            dataTypes.add(data_type);
        }
        Assert.assertEquals((String)"table should have two columns", (long)2L, (long)colNames.size());
        Assert.assertEquals((Object)"key", colNames.get(0));
        Assert.assertEquals((Object)"value", colNames.get(1));
        Assert.assertEquals((Object)"int", dataTypes.get(0));
        Assert.assertEquals((Object)"string", dataTypes.get(1));
        String filepath = String.valueOf(testDir) + "/a.txt";
        sql = "load data inpath '" + filepath + "' into table " + tableName;
        res = stmt.executeQuery(sql);
        sql = "select * from " + tableName;
        res = stmt.executeQuery(sql);
        ArrayList<Integer> keys = new ArrayList<Integer>();
        ArrayList<String> values = new ArrayList<String>();
        while (res.next()) {
            int key = res.getInt(1);
            String value = res.getString(2);
            keys.add(new Integer(key));
            values.add(value);
        }
        Assert.assertEquals((String)"table should have two rows", (long)2L, (long)keys.size());
        Assert.assertEquals((Object)new Integer(1), keys.get(0));
        Assert.assertEquals((Object)new Integer(2), keys.get(1));
        Assert.assertEquals((Object)"foo", values.get(0));
        Assert.assertEquals((Object)"bar", values.get(1));
    }
}

