/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bigtop.itest.datafu.stats;

import java.util.Iterator;
import org.apache.bigtop.itest.datafu.PigTests;
import org.apache.pig.data.Tuple;
import org.apache.pig.pigunit.PigTest;
import org.junit.Assert;
import org.junit.Test;

public class MarkovPairTests
extends PigTests {
    @Test
    public void markovPairDefaultTest() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/markovPairDefault.pig", "schema=(data: bag {t: tuple(val:int)})");
        this.writeLinesToFile("input", "{(10),(20),(30),(40),(50),(60)}");
        String[] expectedOutput = new String[]{"({((10),(20)),((20),(30)),((30),(40)),((40),(50)),((50),(60))})"};
        test.runScript();
        Iterator actualOutput = test.getAlias("data_out");
        this.assertTuplesMatch(expectedOutput, actualOutput);
    }

    @Test
    public void markovPairMultipleInput() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/markovPairDefault.pig", "schema=(data: bag {t: tuple(val1:int,val2:int)})");
        this.writeLinesToFile("input", "{(10,100),(20,200),(30,300),(40,400),(50,500),(60,600)}");
        String[] expectedOutput = new String[]{"({((10,100),(20,200)),((20,200),(30,300)),((30,300),(40,400)),((40,400),(50,500)),((50,500),(60,600))})"};
        test.runScript();
        Iterator actualOutput = test.getAlias("data_out");
        this.assertTuplesMatch(expectedOutput, actualOutput);
    }

    @Test
    public void markovPairLookaheadTest() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/markovPairLookahead.pig", "schema=(data: bag {t: tuple(val:int)})", "lookahead=3");
        this.writeLinesToFile("input", "{(10),(20),(30),(40),(50)}");
        String[] expectedOutput = new String[]{"({((10),(20)),((10),(30)),((10),(40)),((20),(30)),((20),(40)),((20),(50)),((30),(40)),((30),(50)),((40),(50))})"};
        test.runScript();
        Iterator actualOutput = test.getAlias("data_out");
        this.assertTuplesMatch(expectedOutput, actualOutput);
    }

    private void assertTuplesMatch(String[] expectedOutput, Iterator<Tuple> actualOutput) {
        Iterator<Tuple> tuples = actualOutput;
        String[] stringArray = expectedOutput;
        int n = expectedOutput.length;
        int n2 = 0;
        while (n2 < n) {
            String outputLine = stringArray[n2];
            Assert.assertTrue((boolean)tuples.hasNext());
            Tuple outputTuple = tuples.next();
            System.out.println(String.format("expected: %s", outputLine));
            System.out.println(String.format("actual: %s", outputTuple.toString()));
            Assert.assertEquals((Object)outputLine, (Object)outputTuple.toString());
            ++n2;
        }
    }
}

