/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bigtop.itest.datafu.linkanalysis;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.bigtop.itest.datafu.PigTests;
import org.apache.bigtop.itest.datafu.linkanalysis.PageRankTest;
import org.apache.pig.data.Tuple;
import org.apache.pig.pigunit.PigTest;
import org.junit.Assert;
import org.junit.Test;

public class PageRankTests
extends PigTests {
    @Test
    public void pigPageRankTest() throws Exception {
        PigTest test = this.createPigTest("datafu/linkanalysis/pageRankTest.pig");
        String[] edges = PageRankTest.getWikiExampleEdges();
        HashMap<String, Integer> nodeIds = new HashMap<String, Integer>();
        HashMap<Integer, String> nodeIdsReversed = new HashMap<Integer, String>();
        Map<String, Float> expectedRanks = PageRankTest.parseExpectedRanks(PageRankTest.getWikiExampleExpectedRanks());
        File f = new File(System.getProperty("user.dir"), "input").getAbsoluteFile();
        if (f.exists()) {
            f.delete();
        }
        FileWriter writer = new FileWriter(f);
        BufferedWriter bufferedWriter = new BufferedWriter(writer);
        String[] stringArray = edges;
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            int id;
            String edge = stringArray[n2];
            String[] edgeParts = edge.split(" ");
            String source = edgeParts[0];
            String dest = edgeParts[1];
            if (!nodeIds.containsKey(source)) {
                id = nodeIds.size();
                nodeIds.put(source, id);
                nodeIdsReversed.put(id, source);
            }
            if (!nodeIds.containsKey(dest)) {
                id = nodeIds.size();
                nodeIds.put(dest, id);
                nodeIdsReversed.put(id, dest);
            }
            Integer sourceId = (Integer)nodeIds.get(source);
            Integer destId = (Integer)nodeIds.get(dest);
            StringBuffer sb = new StringBuffer();
            sb.append("1\t");
            sb.append(String.valueOf(sourceId.toString()) + "\t");
            sb.append(String.valueOf(destId.toString()) + "\t");
            sb.append("1.0\n");
            bufferedWriter.write(sb.toString());
            ++n2;
        }
        bufferedWriter.close();
        test.runScript();
        Iterator tuples = test.getAlias("data_grouped3");
        System.out.println("Final node ranks:");
        int nodeCount = 0;
        while (tuples.hasNext()) {
            Tuple nodeTuple = (Tuple)tuples.next();
            Integer topic = (Integer)nodeTuple.get(0);
            Integer nodeId = (Integer)nodeTuple.get(1);
            Float nodeRank = (Float)nodeTuple.get(2);
            Assert.assertEquals((long)1L, (long)topic.intValue());
            System.out.println(String.format("%d => %f", nodeId, nodeRank));
            Float expectedNodeRank = expectedRanks.get(nodeIdsReversed.get(nodeId));
            Assert.assertTrue((String)String.format("expected: %f, actual: %f", expectedNodeRank, nodeRank), ((double)Math.abs(expectedNodeRank.floatValue() - nodeRank.floatValue() * 100.0f) < 0.1 ? 1 : 0) != 0);
            ++nodeCount;
        }
        Assert.assertEquals((long)nodeIds.size(), (long)nodeCount);
    }
}

