/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bigtop.itest.datafu;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.pig.data.Tuple;
import org.apache.pig.pigunit.PigTest;
import org.apache.pig.tools.parameters.ParseException;
import org.junit.Assert;

public abstract class PigTests {
    protected String[] getDefaultArgs() {
        String[] args = new String[]{"JAR_PATH=" + this.getJarPath()};
        return args;
    }

    protected List<String> getDefaultArgsAsList() {
        String[] args = this.getDefaultArgs();
        ArrayList<String> argsList = new ArrayList<String>(args.length);
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            argsList.add(arg);
            ++n2;
        }
        return argsList;
    }

    protected PigTest createPigTest(String scriptPath, String ... args) throws IOException {
        List<String> theArgs = this.getDefaultArgsAsList();
        String[] stringArray = args;
        int n = args.length;
        int n2 = 0;
        while (n2 < n) {
            String arg = stringArray[n2];
            theArgs.add(arg);
            ++n2;
        }
        String[] lines = this.getLinesFromFile(scriptPath);
        for (String arg : theArgs) {
            String[] parts = arg.split("=", 2);
            if (parts.length != 2) continue;
            int i = 0;
            while (i < lines.length) {
                lines[i] = lines[i].replaceAll(Pattern.quote("$" + parts[0]), parts[1]);
                ++i;
            }
        }
        return new PigTest(lines);
    }

    protected PigTest createPigTest(String scriptPath) throws IOException {
        return this.createPigTest(scriptPath, this.getDefaultArgs());
    }

    protected String getJarPath() {
        String jarDirPath;
        File userDir;
        String[] files;
        String jarDir = "dist";
        if (System.getProperty("datafu.jar.dir") != null) {
            jarDir = System.getProperty("datafu.jar.dir");
        }
        if ((files = (userDir = new File(jarDirPath = new File(jarDir).getAbsolutePath())).list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("datafu") && name.endsWith(".jar") && !name.contains("sources") && !name.contains("javadoc");
            }
        })).length == 0) {
            throw new RuntimeException("Could not find JAR file");
        }
        if (files.length > 1) {
            throw new RuntimeException("Found more JAR files than expected");
        }
        return String.valueOf(userDir.getAbsolutePath()) + "/" + files[0];
    }

    protected List<Tuple> getLinesForAlias(PigTest test, String alias) throws IOException, ParseException {
        return this.getLinesForAlias(test, alias, true);
    }

    protected List<Tuple> getLinesForAlias(PigTest test, String alias, boolean logValues) throws IOException, ParseException {
        Iterator tuplesIterator = test.getAlias(alias);
        ArrayList<Tuple> tuples = new ArrayList<Tuple>();
        if (logValues) {
            System.out.println(String.format("Values for %s: ", alias));
        }
        while (tuplesIterator.hasNext()) {
            Tuple tuple = (Tuple)tuplesIterator.next();
            if (logValues) {
                System.out.println(tuple.toString());
            }
            tuples.add(tuple);
        }
        return tuples;
    }

    protected void writeLinesToFile(String fileName, String ... lines) throws IOException {
        File inputFile = this.deleteIfExists(this.getFile(fileName));
        this.writeLinesToFile(inputFile, lines);
    }

    protected void writeLinesToFile(File file, String[] lines) throws IOException {
        FileWriter writer = new FileWriter(file);
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            writer.write(String.valueOf(line) + "\n");
            ++n2;
        }
        writer.close();
    }

    protected void assertOutput(PigTest test, String alias, String ... expected) throws IOException, ParseException {
        List<Tuple> tuples = this.getLinesForAlias(test, alias);
        Assert.assertEquals((long)expected.length, (long)tuples.size());
        int i = 0;
        String[] stringArray = expected;
        int n = expected.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            Assert.assertEquals((Object)e, (Object)tuples.get(i++).toString());
            ++n2;
        }
    }

    protected File deleteIfExists(File file) {
        if (file.exists()) {
            file.delete();
        }
        return file;
    }

    protected File getFile(String fileName) {
        return new File(System.getProperty("user.dir"), fileName).getAbsoluteFile();
    }

    protected String[] getLinesFromFile(String relativeFilePath) throws IOException {
        File file = new File(System.getProperty("user.dir"), relativeFilePath).getAbsoluteFile();
        BufferedInputStream content = new BufferedInputStream(new FileInputStream(file));
        Object[] lines = IOUtils.readLines((InputStream)content).toArray();
        String[] result = new String[lines.length];
        int i = 0;
        while (i < lines.length) {
            result[i] = (String)lines[i];
            ++i;
        }
        return result;
    }
}

