/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bigtop.itest.datafu.stats;

import java.util.ArrayList;
import java.util.List;
import org.apache.bigtop.itest.datafu.PigTests;
import org.apache.pig.data.Tuple;
import org.apache.pig.pigunit.PigTest;
import org.junit.Assert;
import org.junit.Test;

public class QuantileTests
extends PigTests {
    @Test
    public void quantileTest() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/quantileTest.pig", "QUANTILES='0.0','0.25','0.5','0.75','1.0'");
        String[] input = new String[]{"1", "2", "3", "4", "10", "5", "6", "7", "8", "9"};
        this.writeLinesToFile("input", input);
        test.runScript();
        List<Tuple> output = this.getLinesForAlias(test, "data_out", true);
        Assert.assertEquals((long)output.size(), (long)1L);
        Assert.assertEquals((Object)output.get(0).toString(), (Object)"(1.0,3.0,5.5,8.0,10.0)");
    }

    @Test
    public void quantile2Test() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/quantileTest.pig", "QUANTILES='5'");
        String[] input = new String[]{"1", "2", "3", "4", "10", "5", "6", "7", "8", "9"};
        this.writeLinesToFile("input", input);
        test.runScript();
        List<Tuple> output = this.getLinesForAlias(test, "data_out", true);
        Assert.assertEquals((long)output.size(), (long)1L);
        Assert.assertEquals((Object)output.get(0).toString(), (Object)"(1.0,3.0,5.5,8.0,10.0)");
    }

    @Test
    public void medianTest() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/medianTest.pig");
        String[] input = new String[]{"4", "5", "6", "9", "10", "7", "8", "2", "3", "1"};
        this.writeLinesToFile("input", input);
        test.runScript();
        List<Tuple> output = this.getLinesForAlias(test, "data_out", true);
        Assert.assertEquals((long)output.size(), (long)1L);
        Assert.assertEquals((Object)output.get(0).toString(), (Object)"(5.5)");
    }

    @Test
    public void streamingMedianTest() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/streamingMedianTest.pig");
        String[] input = new String[]{"0", "4", "5", "6", "9", "10", "7", "8", "2", "3", "1"};
        this.writeLinesToFile("input", input);
        test.runScript();
        List<Tuple> output = this.getLinesForAlias(test, "data_out", true);
        Assert.assertEquals((long)output.size(), (long)1L);
        Assert.assertEquals((Object)output.get(0).toString(), (Object)"(5.0)");
    }

    @Test
    public void streamingQuantileTest() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/streamingQuantileTest.pig", "QUANTILES='5'");
        String[] input = new String[]{"1", "2", "3", "4", "10", "5", "6", "7", "8", "9"};
        this.writeLinesToFile("input", input);
        test.runScript();
        List<Tuple> output = this.getLinesForAlias(test, "data_out", true);
        Assert.assertEquals((long)output.size(), (long)1L);
        Assert.assertEquals((Object)output.get(0).toString(), (Object)"(1.0,3.0,5.0,8.0,10.0)");
    }

    @Test
    public void streamingQuantile2Test() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/streamingQuantileTest.pig", "QUANTILES='0.5','0.75','1.0'");
        String[] input = new String[]{"1", "2", "3", "4", "10", "5", "6", "7", "8", "9"};
        this.writeLinesToFile("input", input);
        test.runScript();
        List<Tuple> output = this.getLinesForAlias(test, "data_out", true);
        Assert.assertEquals((long)output.size(), (long)1L);
        Assert.assertEquals((Object)output.get(0).toString(), (Object)"(5.0,8.0,10.0)");
    }

    @Test
    public void streamingQuantile3Test() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/streamingQuantileTest.pig", "QUANTILES='0.07','0.03','0.37','1.0','0.0'");
        ArrayList<String> input = new ArrayList<String>();
        int i = 1000;
        while (i >= 1) {
            input.add(Integer.toString(i));
            --i;
        }
        this.writeLinesToFile("input", input.toArray(new String[0]));
        test.runScript();
        List<Tuple> output = this.getLinesForAlias(test, "data_out", true);
        Assert.assertEquals((long)output.size(), (long)1L);
        Assert.assertEquals((Object)output.get(0).toString(), (Object)"(70.0,30.0,370.0,1000.0,1.0)");
    }

    @Test
    public void streamingQuantile4Test() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/streamingQuantileTest.pig", "QUANTILES='0.0013','0.0228','0.1587','0.5','0.8413','0.9772','0.9987'");
        ArrayList<String> input = new ArrayList<String>();
        int i = 100000;
        while (i >= 0) {
            input.add(Integer.toString(i));
            --i;
        }
        this.writeLinesToFile("input", input.toArray(new String[0]));
        test.runScript();
        List<Tuple> output = this.getLinesForAlias(test, "data_out", true);
        Assert.assertEquals((long)output.size(), (long)1L);
        Assert.assertEquals((Object)output.get(0).toString(), (Object)"(130.0,2280.0,15870.0,50000.0,84130.0,97720.0,99870.0)");
    }

    @Test
    public void quantile3Test() throws Exception {
        PigTest test = this.createPigTest("datafu/stats/quantileTest.pig", "QUANTILES='0.0013','0.0228','0.1587','0.5','0.8413','0.9772','0.9987'");
        ArrayList<String> input = new ArrayList<String>();
        int i = 100000;
        while (i >= 0) {
            input.add(Integer.toString(i));
            --i;
        }
        this.writeLinesToFile("input", input.toArray(new String[0]));
        test.runScript();
        List<Tuple> output = this.getLinesForAlias(test, "data_out", true);
        Assert.assertEquals((long)output.size(), (long)1L);
        Assert.assertEquals((Object)output.get(0).toString(), (Object)"(130.0,2280.0,15870.0,50000.0,84130.0,97720.0,99870.0)");
    }
}

