/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bigtop.itest.datafu.linkanalysis;

import datafu.linkanalysis.PageRank;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.junit.Test;

public class PageRankTest {
    @Test
    public void wikipediaGraphInMemoryTest() throws Exception {
        System.out.println();
        System.out.println("Starting wikipediaGraphInMemoryTest");
        PageRank graph = new PageRank();
        String[] edges = PageRankTest.getWikiExampleEdges();
        Map<String, Integer> nodeIdsMap = this.loadGraphFromEdgeList(graph, edges);
        graph.enableDanglingNodeHandling();
        this.performIterations(graph, 150, 1.0E-18f);
        String[] expectedRanks = PageRankTest.getWikiExampleExpectedRanks();
        Map<String, Float> expectedRanksMap = PageRankTest.parseExpectedRanks(expectedRanks);
        this.validateExpectedRanks(graph, nodeIdsMap, expectedRanksMap);
    }

    @Test
    public void wikipediaGraphDiskCacheTest() throws Exception {
        System.out.println();
        System.out.println("Starting wikipediaGraphDiskCacheTest");
        PageRank graph = new PageRank();
        String[] edges = PageRankTest.getWikiExampleEdges();
        graph.enableEdgeDiskCaching();
        graph.setEdgeCachingThreshold(5L);
        Map<String, Integer> nodeIdsMap = this.loadGraphFromEdgeList(graph, edges);
        assert (graph.isUsingEdgeDiskCache()) : "Expected disk cache to be used";
        graph.enableDanglingNodeHandling();
        this.performIterations(graph, 150, 1.0E-18f);
        String[] expectedRanks = PageRankTest.getWikiExampleExpectedRanks();
        Map<String, Float> expectedRanksMap = PageRankTest.parseExpectedRanks(expectedRanks);
        this.validateExpectedRanks(graph, nodeIdsMap, expectedRanksMap);
    }

    @Test
    public void hubAndSpokeInMemoryTest() throws Exception {
        System.out.println();
        System.out.println("Starting hubAndSpokeInMemoryTest");
        PageRank graph = new PageRank();
        String[] edges = this.getHubAndSpokeEdges();
        this.loadGraphFromEdgeList(graph, edges);
        graph.enableDanglingNodeHandling();
        this.performIterations(graph, 150, 1.0E-18f);
    }

    @Test
    public void hubAndSpokeDiskCacheTest() throws Exception {
        System.out.println();
        System.out.println("Starting hubAndSpokeDiskCacheTest");
        PageRank graph = new PageRank();
        String[] edges = this.getHubAndSpokeEdges();
        graph.enableEdgeDiskCaching();
        graph.setEdgeCachingThreshold(5L);
        this.loadGraphFromEdgeList(graph, edges);
        graph.enableDanglingNodeHandling();
        this.performIterations(graph, 150, 1.0E-18f);
    }

    private String[] getHubAndSpokeEdges() {
        int count = 50000;
        String[] edges = new String[count];
        int i = 0;
        while (i < count) {
            edges[i] = String.format("S%d H", i);
            ++i;
        }
        return edges;
    }

    public static String[] getWikiExampleEdges() {
        String[] edges = new String[]{"B C", "C B", "D A", "D B", "E D", "E B", "E F", "F E", "F B", "P1 B", "P1 E", "P2 B", "P2 E", "P3 B", "P3 E", "P4 E", "P5 E"};
        return edges;
    }

    public static String[] getWikiExampleExpectedRanks() {
        String[] expectedRanks = new String[]{"A 3.3", "B 38.4", "C 34.3", "D 3.9", "E 8.1", "F 3.9", "P1 1.6", "P2 1.6", "P3 1.6", "P4 1.6", "P5 1.6"};
        return expectedRanks;
    }

    private Map<String, Integer> loadGraphFromEdgeList(PageRank graph, String[] edges) throws IOException {
        HashMap<Integer, ArrayList> nodeEdgesMap = new HashMap<Integer, ArrayList>();
        HashMap<String, Integer> nodeIdsMap = new HashMap<String, Integer>();
        String[] stringArray = edges;
        int n = edges.length;
        int n2 = 0;
        while (n2 < n) {
            String edge = stringArray[n2];
            String[] parts = edge.split(" ");
            assert (parts.length == 2) : "Expected two parts";
            int sourceId = this.getOrCreateId(parts[0], nodeIdsMap);
            int destId = this.getOrCreateId(parts[1], nodeIdsMap);
            HashMap<String, Number> edgeMap = new HashMap<String, Number>();
            edgeMap.put("weight", 1.0);
            edgeMap.put("dest", destId);
            ArrayList nodeEdges = null;
            if (nodeEdgesMap.containsKey(sourceId)) {
                nodeEdges = (ArrayList)nodeEdgesMap.get(sourceId);
            } else {
                nodeEdges = new ArrayList();
                nodeEdgesMap.put(sourceId, nodeEdges);
            }
            nodeEdges.add(edgeMap);
            ++n2;
        }
        for (Map.Entry e : nodeEdgesMap.entrySet()) {
            graph.addEdges((Integer)e.getKey(), (ArrayList)e.getValue());
        }
        return nodeIdsMap;
    }

    private void performIterations(PageRank graph, int maxIters, float tolerance) throws IOException {
        float totalDiff;
        System.out.println(String.format("Beginning iteration (maxIters = %d, tolerance=%e)", maxIters, Float.valueOf(tolerance)));
        PageRank.ProgressIndicator progressIndicator = this.getDummyProgressIndicator();
        System.out.println("Initializing graph");
        long startTime = System.nanoTime();
        graph.init(progressIndicator);
        System.out.println(String.format("Done, took %f ms", (double)(System.nanoTime() - startTime) / 1.0E7));
        int iter = 0;
        System.out.println("Beginning iterations");
        startTime = System.nanoTime();
        do {
            totalDiff = graph.nextIteration(progressIndicator);
        } while (++iter < maxIters && totalDiff > tolerance);
        System.out.println(String.format("Done, took %f ms", (double)(System.nanoTime() - startTime) / 1.0E7));
    }

    private PageRank.ProgressIndicator getDummyProgressIndicator() {
        return new PageRank.ProgressIndicator(){

            @Override
            public void progress() {
            }
        };
    }

    private void validateExpectedRanks(PageRank graph, Map<String, Integer> nodeIds, Map<String, Float> expectedRanks) {
        System.out.println("Validating page rank results");
        for (Map.Entry<String, Integer> e : nodeIds.entrySet()) {
            float rank = graph.getNodeRank(e.getValue());
            float expectedRank = expectedRanks.get(e.getKey()).floatValue();
            assert ((double)Math.abs(expectedRank - rank * 100.0f) < 0.1) : String.format("Did not get expected rank for %s", e.getKey());
        }
        System.out.println("All ranks match expected");
    }

    public static Map<String, Float> parseExpectedRanks(String[] expectedRanks) {
        HashMap<String, Float> expectedRanksMap = new HashMap<String, Float>();
        String[] stringArray = expectedRanks;
        int n = expectedRanks.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedRankString = stringArray[n2];
            String[] parts = expectedRankString.split(" ");
            assert (parts.length == 2) : "Expected two parts";
            String name = parts[0];
            Float expectedRank = Float.valueOf(Float.parseFloat(parts[1]));
            expectedRanksMap.put(name, expectedRank);
            ++n2;
        }
        return expectedRanksMap;
    }

    private Integer getOrCreateId(String name, Map<String, Integer> nodeIds) {
        if (nodeIds.containsKey(name)) {
            return nodeIds.get(name);
        }
        Integer id = nodeIds.size();
        nodeIds.put(name, id);
        return id;
    }
}

