/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bigtop.itest.datafu.geo;

import java.util.List;
import org.apache.bigtop.itest.datafu.PigTests;
import org.apache.pig.data.Tuple;
import org.apache.pig.pigunit.PigTest;
import org.junit.Assert;
import org.junit.Test;

public class GeoTests
extends PigTests {
    @Test
    public void haversineTest() throws Exception {
        PigTest test = this.createPigTest("datafu/geo/haversineTest.pig");
        double[] la = new double[]{34.040143, -118.243103};
        double[] tokyo = new double[]{35.637209, 139.65271};
        double[] ny = new double[]{40.716038, -73.99498};
        double[] paris = new double[]{48.857713, 2.342491};
        double[] sydney = new double[]{-33.872696, 151.195221};
        this.writeLinesToFile("input", this.coords(la, tokyo), this.coords(ny, tokyo), this.coords(ny, sydney), this.coords(ny, paris));
        test.runScript();
        List<Tuple> distances = this.getLinesForAlias(test, "data2");
        this.assertWithin(5478.0, distances.get(0), 20.0);
        this.assertWithin(6760.0, distances.get(1), 20.0);
        this.assertWithin(9935.0, distances.get(2), 20.0);
        this.assertWithin(3635.0, distances.get(3), 20.0);
    }

    private void assertWithin(double expected, Tuple actual, double maxDiff) throws Exception {
        Double actualVal = (Double)actual.get(0);
        Assert.assertTrue((Math.abs(expected - actualVal) < maxDiff ? 1 : 0) != 0);
    }

    private String coords(double[] coords1, double[] coords2) {
        Assert.assertTrue((coords1.length == 2 ? 1 : 0) != 0);
        Assert.assertTrue((coords2.length == 2 ? 1 : 0) != 0);
        return String.format("%f\t%f\t%f\t%f", coords1[0], coords1[1], coords2[0], coords2[1]);
    }
}

