/*
 * Decompiled with CFR 0.152.
 */
package datafu.linkanalysis;

import com.google.common.collect.AbstractIterator;
import it.unimi.dsi.fastutil.floats.FloatArrayList;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class PageRank {
    private float totalRankChange;
    private long edgeCount;
    private long nodeCount;
    private static float ALPHA = 0.85f;
    private static float EDGE_WEIGHT_MULTIPLIER = 100000.0f;
    private final Int2IntOpenHashMap nodeIndices = new Int2IntOpenHashMap();
    private final FloatArrayList nodeData = new FloatArrayList();
    private final IntArrayList danglingNodes = new IntArrayList();
    private final IntArrayList edges = new IntArrayList();
    private boolean shouldHandleDanglingNodes = false;
    private boolean shouldCacheEdgesOnDisk = false;
    private long edgeCachingThreshold;
    private File edgesFile;
    private DataOutputStream edgeDataOutputStream;
    private boolean usingEdgeDiskCache;

    public void clear() throws IOException {
        this.edgeCount = 0L;
        this.nodeCount = 0L;
        this.totalRankChange = 0.0f;
        this.nodeIndices.clear();
        this.nodeData.clear();
        this.edges.clear();
        this.danglingNodes.clear();
        if (this.edgeDataOutputStream != null) {
            this.edgeDataOutputStream.close();
            this.edgeDataOutputStream = null;
        }
        this.usingEdgeDiskCache = false;
        this.edgesFile = null;
    }

    public boolean isUsingEdgeDiskCache() {
        return this.usingEdgeDiskCache;
    }

    public void enableEdgeDiskCaching() {
        this.shouldCacheEdgesOnDisk = true;
    }

    public void disableEdgeDiskCaching() {
        this.shouldCacheEdgesOnDisk = false;
    }

    public boolean isEdgeDiskCachingEnabled() {
        return this.shouldCacheEdgesOnDisk;
    }

    public long getEdgeCachingThreshold() {
        return this.edgeCachingThreshold;
    }

    public void setEdgeCachingThreshold(long count) {
        this.edgeCachingThreshold = count;
    }

    public void enableDanglingNodeHandling() {
        this.shouldHandleDanglingNodes = true;
    }

    public void disableDanglingNodeHandling() {
        this.shouldHandleDanglingNodes = false;
    }

    public long nodeCount() {
        return this.nodeCount;
    }

    public long edgeCount() {
        return this.edgeCount;
    }

    public Int2IntMap.FastEntrySet getNodeIds() {
        return this.nodeIndices.int2IntEntrySet();
    }

    public float getNodeRank(int nodeId) {
        int nodeIndex = this.nodeIndices.get(nodeId);
        return this.nodeData.get(nodeIndex).floatValue();
    }

    public float getTotalRankChange() {
        return this.totalRankChange;
    }

    private void maybeCreateNode(int nodeId) {
        if (!this.nodeIndices.containsKey(nodeId)) {
            int index = this.nodeData.size();
            this.nodeData.add(0.0f);
            this.nodeData.add(0.0f);
            this.nodeData.add(0.0f);
            this.nodeIndices.put(nodeId, index);
            ++this.nodeCount;
        }
    }

    public void addEdges(Integer sourceId, ArrayList<Map<String, Object>> sourceEdges) throws IOException {
        int source = sourceId;
        this.maybeCreateNode(source);
        if (this.shouldCacheEdgesOnDisk && !this.usingEdgeDiskCache && (long)sourceEdges.size() + this.edgeCount >= this.edgeCachingThreshold) {
            this.writeEdgesToDisk();
        }
        this.appendEdgeData(source);
        this.appendEdgeData(sourceEdges.size());
        for (Map<String, Object> edge : sourceEdges) {
            int dest = (Integer)edge.get("dest");
            float weight = ((Double)edge.get("weight")).floatValue();
            this.maybeCreateNode(dest);
            this.appendEdgeData(dest);
            this.appendEdgeData(Math.max(1, (int)(weight * EDGE_WEIGHT_MULTIPLIER)));
            ++this.edgeCount;
        }
    }

    private void appendEdgeData(int data) throws IOException {
        if (this.edgeDataOutputStream != null) {
            this.edgeDataOutputStream.writeInt(data);
        } else {
            this.edges.add(data);
        }
    }

    public void init(ProgressIndicator progressIndicator) throws IOException {
        float totalWeight;
        int nodeIndex;
        if (this.edgeDataOutputStream != null) {
            this.edgeDataOutputStream.close();
            this.edgeDataOutputStream = null;
        }
        float nodeRank = 1.0f / (float)this.nodeCount;
        int j = 0;
        while (j < this.nodeData.size()) {
            this.nodeData.set(j, nodeRank);
            progressIndicator.progress();
            j += 3;
        }
        Iterator<Integer> edgeData = this.getEdgeData();
        while (edgeData.hasNext()) {
            int sourceId = edgeData.next();
            int nodeEdgeCount = edgeData.next();
            while (nodeEdgeCount-- > 0) {
                edgeData.next();
                float weight = edgeData.next().intValue();
                nodeIndex = this.nodeIndices.get(sourceId);
                totalWeight = this.nodeData.getFloat(nodeIndex + 1);
                this.nodeData.set(nodeIndex + 1, totalWeight += weight);
                progressIndicator.progress();
            }
        }
        if (this.shouldHandleDanglingNodes) {
            for (Map.Entry e : this.nodeIndices.entrySet()) {
                int nodeId = (Integer)e.getKey();
                nodeIndex = (Integer)e.getValue();
                totalWeight = this.nodeData.getFloat(nodeIndex + 1);
                if (totalWeight != 0.0f) continue;
                this.danglingNodes.add(nodeId);
            }
        }
    }

    public float nextIteration(ProgressIndicator progressIndicator) throws IOException {
        this.distribute(progressIndicator);
        this.commit(progressIndicator);
        return this.getTotalRankChange();
    }

    public void distribute(ProgressIndicator progressIndicator) throws IOException {
        Iterator<Integer> edgeData = this.getEdgeData();
        while (edgeData.hasNext()) {
            int sourceId = edgeData.next();
            int nodeEdgeCount = edgeData.next();
            while (nodeEdgeCount-- > 0) {
                int toId = edgeData.next();
                float weight = edgeData.next().intValue();
                int fromNodeIndex = this.nodeIndices.get(sourceId);
                int toNodeIndex = this.nodeIndices.get(toId);
                float contributionChange = weight * this.nodeData.getFloat(fromNodeIndex) / this.nodeData.getFloat(fromNodeIndex + 1);
                float currentContribution = this.nodeData.getFloat(toNodeIndex + 2);
                this.nodeData.set(toNodeIndex + 2, currentContribution + contributionChange);
                progressIndicator.progress();
            }
        }
        if (this.shouldHandleDanglingNodes) {
            float totalRank = 0.0f;
            Iterator toId = this.danglingNodes.iterator();
            while (toId.hasNext()) {
                int nodeId = (Integer)toId.next();
                int nodeIndex = this.nodeIndices.get(nodeId);
                float rank = this.nodeData.get(nodeIndex).floatValue();
                totalRank += rank;
            }
            float contributionIncrease = totalRank / (float)this.nodeCount;
            int i = 2;
            while (i < this.nodeData.size()) {
                float contribution = this.nodeData.getFloat(i);
                this.nodeData.set(i, contribution += contributionIncrease);
                i += 3;
            }
        }
    }

    public void commit(ProgressIndicator progressIndicator) {
        this.totalRankChange = 0.0f;
        Iterator iterator = this.nodeIndices.keySet().iterator();
        while (iterator.hasNext()) {
            int id = (Integer)iterator.next();
            int nodeIndex = this.nodeIndices.get(id);
            float alpha = ALPHA;
            float newRank = (1.0f - alpha) / (float)this.nodeCount + alpha * this.nodeData.get(nodeIndex + 2).floatValue();
            this.nodeData.set(nodeIndex + 2, 0.0f);
            float lastRankDiff = newRank - this.nodeData.get(nodeIndex).floatValue();
            this.nodeData.set(nodeIndex, newRank);
            this.totalRankChange += Math.abs(lastRankDiff);
            progressIndicator.progress();
        }
    }

    private void writeEdgesToDisk() throws IOException {
        this.edgesFile = File.createTempFile("fastgraph", null);
        FileOutputStream outStream = new FileOutputStream(this.edgesFile);
        BufferedOutputStream bufferedStream = new BufferedOutputStream(outStream);
        this.edgeDataOutputStream = new DataOutputStream(bufferedStream);
        Iterator iterator = this.edges.iterator();
        while (iterator.hasNext()) {
            int edgeData = (Integer)iterator.next();
            this.edgeDataOutputStream.writeInt(edgeData);
        }
        this.edges.clear();
        this.usingEdgeDiskCache = true;
    }

    private Iterator<Integer> getEdgeData() throws IOException {
        if (!this.usingEdgeDiskCache) {
            return this.edges.iterator();
        }
        FileInputStream fileInputStream = new FileInputStream(this.edgesFile);
        BufferedInputStream inputStream = new BufferedInputStream(fileInputStream);
        final DataInputStream dataInputStream = new DataInputStream(inputStream);
        return new AbstractIterator<Integer>(){

            protected Integer computeNext() {
                try {
                    return dataInputStream.readInt();
                }
                catch (IOException iOException) {
                    return (Integer)this.endOfData();
                }
            }
        };
    }

    public static interface ProgressIndicator {
        public void progress();
    }
}

