/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc.parser;

import java.lang.reflect.Method;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.system.jdbc.TypeMappingsFactory;
import org.apache.beehive.controls.system.jdbc.parser.LiteralFragment;
import org.apache.beehive.controls.system.jdbc.parser.ReflectionFragment;
import org.apache.beehive.controls.system.jdbc.parser.SqlFragment;
import org.apache.beehive.controls.system.jdbc.parser.SqlFragmentContainer;

public class SqlSubstitutionFragment
extends SqlFragmentContainer {
    SqlSubstitutionFragment(SqlFragment child) {
        this.addChild(child);
    }

    SqlSubstitutionFragment(LiteralFragment lf, ReflectionFragment rf, LiteralFragment lff) {
        this.addChild(lf);
        this.addChild(rf);
        this.addChild(lff);
    }

    boolean isDynamicFragment() {
        return true;
    }

    boolean hasParamValue() {
        return false;
    }

    String getPreparedStatementText(ControlBeanContext context, Method m, Object[] args) {
        StringBuilder sb = new StringBuilder();
        for (SqlFragment frag : this._children) {
            if (frag.hasParamValue()) {
                Object[] pValues;
                for (Object o : pValues = frag.getParameterValues(context, m, args)) {
                    sb.append(this.processSqlParams(o));
                }
                continue;
            }
            sb.append(frag.getPreparedStatementText(context, m, args));
        }
        return sb.toString();
    }

    private String processSqlParams(Object value) {
        Object[] arr = null;
        if (value != null) {
            arr = TypeMappingsFactory.toObjectArray(value);
        }
        if (value == null || arr != null && arr.length == 0) {
            return "";
        }
        if (arr != null) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    result.append(',');
                    result.append(arr[i].toString());
                    continue;
                }
                result.append(arr[i].toString());
            }
            return result.toString();
        }
        return value.toString();
    }
}

