/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc.parser;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import javax.sql.RowSet;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.system.jdbc.JdbcControl;
import org.apache.beehive.controls.system.jdbc.TypeMappingsFactory;
import org.apache.beehive.controls.system.jdbc.parser.SqlFragment;
import org.apache.beehive.controls.system.jdbc.parser.SqlFragmentContainer;

public final class SqlStatement
extends SqlFragmentContainer
implements Serializable {
    private static final TypeMappingsFactory _tmf = TypeMappingsFactory.getInstance();
    private boolean _callableStatement = false;
    private boolean _cacheableStatement = true;
    private boolean _batchUpdate;
    private boolean _getGeneratedKeys;
    private String[] _genKeyColumnNames;
    private int _fetchSize;
    private int _maxArray;
    private int _maxRows;
    private int[] _genKeyColumnIndexes;
    private JdbcControl.ScrollType _scrollType;
    private JdbcControl.FetchDirection _fetchDirection;
    private JdbcControl.HoldabilityType _holdability;

    SqlStatement() {
    }

    void addChild(SqlFragment frag) {
        super.addChild(frag);
        if (frag.isDynamicFragment()) {
            this._cacheableStatement = false;
        }
    }

    boolean isCacheable() {
        return this._cacheableStatement;
    }

    public boolean isCallableStatement() {
        return this._callableStatement;
    }

    public boolean isBatchUpdate() {
        return this._batchUpdate;
    }

    public boolean getsGeneratedKeys() {
        return this._getGeneratedKeys;
    }

    public PreparedStatement createPreparedStatement(ControlBeanContext context, Connection connection, Calendar calendar, Method method, Object[] arguments) throws SQLException {
        Statement preparedStatement = null;
        this.loadSQLAnnotationStatmentOptions(context, method);
        this.checkJdbcSupport(connection.getMetaData());
        this._callableStatement = this.setCallableStatement(arguments);
        try {
            String sql = this.getPreparedStatementText(context, method, arguments);
            if (this._getGeneratedKeys) {
                if (this._callableStatement) {
                    throw new ControlException("getGeneratedKeys not supported for CallableStatements");
                }
                preparedStatement = this._genKeyColumnNames.length > 0 ? connection.prepareStatement(sql, this._genKeyColumnNames) : (this._genKeyColumnIndexes.length > 0 ? connection.prepareStatement(sql, this._genKeyColumnIndexes) : connection.prepareStatement(sql, 1));
            } else if (this._holdability == JdbcControl.HoldabilityType.DRIVER_DEFAULT) {
                preparedStatement = this._scrollType == JdbcControl.ScrollType.DRIVER_DEFAULT ? (this._callableStatement ? connection.prepareCall(sql) : connection.prepareStatement(sql)) : (this._callableStatement ? connection.prepareCall(sql, this._scrollType.getType(), this._scrollType.getConcurrencyType()) : connection.prepareStatement(sql, this._scrollType.getType(), this._scrollType.getConcurrencyType()));
            } else {
                Statement statement = preparedStatement = this._callableStatement ? connection.prepareCall(sql, this._scrollType.getType(), this._scrollType.getConcurrencyType(), this._holdability.getHoldability()) : connection.prepareStatement(sql, this._scrollType.getType(), this._scrollType.getConcurrencyType(), this._holdability.getHoldability());
            }
            if (this._callableStatement) {
                for (SqlFragment sf : this._children) {
                    if (!sf.hasParamValue()) continue;
                    throw new ControlException("Cannot use parameter substution and SQLParameter array in the same method.");
                }
                JdbcControl.SQLParameter[] params = (JdbcControl.SQLParameter[])arguments[0];
                if (params == null) {
                    return preparedStatement;
                }
                for (int i = 0; i < params.length; ++i) {
                    JdbcControl.SQLParameter p = params[i];
                    if (p.dir != 2) {
                        Object value = params[i].value;
                        this.setPreparedStatementParameter((PreparedStatement)preparedStatement, i + 1, value, params[i].type, calendar);
                    }
                    if (p.dir == 1) continue;
                    ((CallableStatement)preparedStatement).registerOutParameter(i + 1, params[i].type);
                }
            } else if (this._batchUpdate) {
                this.doBatchUpdate((PreparedStatement)preparedStatement, arguments, calendar);
            } else {
                int pIndex = 1;
                for (SqlFragment sf : this._children) {
                    Object[] values;
                    if (!sf.hasParamValue()) continue;
                    for (Object value : values = sf.getParameterValues(context, method, arguments)) {
                        this.setPreparedStatementParameter((PreparedStatement)preparedStatement, pIndex++, value, sf.getParamSqlDataType(), calendar);
                    }
                }
            }
        }
        catch (SQLException e) {
            if (preparedStatement != null) {
                preparedStatement.close();
            }
            throw e;
        }
        preparedStatement.setFetchDirection(this._fetchDirection.getDirection());
        preparedStatement.setFetchSize(this._fetchSize);
        preparedStatement.setMaxRows(this.computeMaxRows(method));
        return preparedStatement;
    }

    public String createPreparedStatementString(ControlBeanContext context, Connection connection, Method method, Object[] arguments) {
        boolean callableStatement = this.setCallableStatement(arguments);
        StringBuilder sqlString = new StringBuilder(this.getPreparedStatementText(context, method, arguments));
        if (callableStatement) {
            JdbcControl.SQLParameter[] params = (JdbcControl.SQLParameter[])arguments[0];
            if (params == null) {
                return sqlString.toString();
            }
            sqlString.append(" Params: {");
            for (int i = 0; i < params.length; ++i) {
                if (i <= 0) continue;
                sqlString.append(params[i].value.toString());
            }
            sqlString.append("}");
        } else if (this._batchUpdate) {
            sqlString.append(" Params: batch update.");
        } else {
            sqlString.append(" Params: {");
            boolean first = true;
            for (SqlFragment sf : this._children) {
                Object[] values;
                if (!sf.hasParamValue()) continue;
                for (Object value : values = sf.getParameterValues(context, method, arguments)) {
                    if (!first) {
                        sqlString.append(", ");
                    } else {
                        first = false;
                    }
                    sqlString.append(value);
                }
            }
            sqlString.append("}");
        }
        return sqlString.toString();
    }

    private void setPreparedStatementParameter(PreparedStatement ps, int i, Object value, int sqlType, Calendar cal) throws SQLException {
        if (sqlType == 0) {
            sqlType = _tmf.getSqlType(value);
        }
        if (value == null) {
            ps.setNull(i, 0 == sqlType ? 12 : sqlType);
            return;
        }
        switch (sqlType) {
            case 12: {
                if (value instanceof String) break;
                value = value.toString();
                break;
            }
            case 16: {
                if (!(value instanceof Boolean)) break;
                ps.setBoolean(i, (Boolean)value);
                return;
            }
            case 93: {
                if (value instanceof Calendar) {
                    Calendar calValue = (Calendar)value;
                    value = new Timestamp(calValue.getTimeInMillis());
                } else if (java.util.Date.class.equals(value.getClass())) {
                    value = new Timestamp(((java.util.Date)value).getTime());
                }
                if (!(value instanceof Timestamp)) break;
                if (cal == null) {
                    ps.setTimestamp(i, (Timestamp)value);
                } else {
                    ps.setTimestamp(i, (Timestamp)value, cal);
                }
                return;
            }
            case 91: {
                if (value instanceof Calendar) {
                    Calendar calValue = (Calendar)value;
                    value = new Date(calValue.getTimeInMillis());
                } else if (value.getClass() == java.util.Date.class) {
                    value = new Date(((java.util.Date)value).getTime());
                }
                if (!(value instanceof Date)) break;
                if (cal == null) {
                    ps.setDate(i, (Date)value);
                } else {
                    ps.setDate(i, (Date)value, cal);
                }
                return;
            }
            case 92: {
                if (!(value instanceof Time)) break;
                if (cal == null) {
                    ps.setTime(i, (Time)value);
                } else {
                    ps.setTime(i, (Time)value, cal);
                }
                return;
            }
        }
        if (sqlType == 0) {
            ps.setObject(i, value);
        } else {
            ps.setObject(i, value, sqlType);
        }
    }

    private boolean setCallableStatement(Object[] args) {
        Class<?> argClass;
        return args != null && args.length == 1 && args[0] != null && (argClass = args[0].getClass()).isArray() && JdbcControl.SQLParameter.class.isAssignableFrom(argClass.getComponentType());
    }

    private void doBatchUpdate(PreparedStatement ps, Object[] args, Calendar cal) throws SQLException {
        int[] sqlTypes = new int[args.length];
        Object[] objArrays = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            sqlTypes[i] = _tmf.getSqlType(args[i].getClass().getComponentType());
            objArrays[i] = TypeMappingsFactory.toObjectArray(args[i]);
        }
        int rowCount = ((Object[])objArrays[0]).length;
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < args.length; ++j) {
                this.setPreparedStatementParameter(ps, j + 1, ((Object[])objArrays[j])[i], sqlTypes[j], cal);
            }
            ps.addBatch();
        }
    }

    private void loadSQLAnnotationStatmentOptions(ControlBeanContext context, Method method) {
        JdbcControl.SQL methodSQL = (JdbcControl.SQL)context.getMethodPropertySet(method, JdbcControl.SQL.class);
        this._batchUpdate = methodSQL.batchUpdate();
        this._getGeneratedKeys = methodSQL.getGeneratedKeys();
        this._genKeyColumnNames = methodSQL.generatedKeyColumnNames();
        this._genKeyColumnIndexes = methodSQL.generatedKeyColumnIndexes();
        this._scrollType = methodSQL.scrollableResultSet();
        this._fetchDirection = methodSQL.fetchDirection();
        this._fetchSize = methodSQL.fetchSize();
        this._maxRows = methodSQL.maxRows();
        this._maxArray = methodSQL.arrayMaxLength();
        this._holdability = methodSQL.resultSetHoldabilityOverride();
    }

    private void checkJdbcSupport(DatabaseMetaData metaData) throws SQLException {
        if (this._getGeneratedKeys && !metaData.supportsGetGeneratedKeys()) {
            throw new ControlException("The database does not support getGeneratedKeys.");
        }
        if (this._batchUpdate && !metaData.supportsBatchUpdates()) {
            throw new ControlException("The database does not support batchUpdates.");
        }
        if (this._scrollType != JdbcControl.ScrollType.DRIVER_DEFAULT && !metaData.supportsResultSetConcurrency(this._scrollType.getType(), this._scrollType.getConcurrencyType())) {
            throw new ControlException("The database does not support the ResultSet concurrecy type: " + this._scrollType.toString());
        }
        if (this._holdability != JdbcControl.HoldabilityType.DRIVER_DEFAULT && !metaData.supportsResultSetHoldability(this._holdability.getHoldability())) {
            throw new ControlException("The database does not support the ResultSet holdability type: " + this._holdability.toString());
        }
    }

    private int computeMaxRows(Method method) {
        Class<?> returnType = method.getReturnType();
        boolean isArray = returnType.isArray();
        boolean isRowSet = returnType.equals(RowSet.class);
        int maxSet = this._maxRows;
        if (isArray && this._maxArray != 0) {
            maxSet = this._maxRows == 0 ? this._maxArray + 1 : Math.min(this._maxArray + 1, this._maxRows);
        } else if (isRowSet && this._maxRows > 0) {
            maxSet = this._maxRows + 1;
        }
        return maxSet;
    }
}

