/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc.parser;

import java.io.StringReader;
import java.util.HashMap;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.system.jdbc.parser.ParseException;
import org.apache.beehive.controls.system.jdbc.parser.SqlGrammar;
import org.apache.beehive.controls.system.jdbc.parser.SqlStatement;
import org.apache.beehive.controls.system.jdbc.parser.TokenMgrError;

public final class SqlParser {
    private HashMap<String, SqlStatement> _cachedSqlStatements = new HashMap();

    public SqlStatement parse(String sql) {
        if (this._cachedSqlStatements.containsKey(sql)) {
            return this._cachedSqlStatements.get(sql);
        }
        SqlGrammar _parser = new SqlGrammar(new StringReader(sql));
        SqlStatement parsed = null;
        try {
            parsed = _parser.parse();
        }
        catch (ParseException e) {
            throw new ControlException("Error parsing SQL statment." + e.getMessage(), (Throwable)e);
        }
        catch (TokenMgrError tme) {
            throw new ControlException("Error parsing SQL statment. " + tme.getMessage(), (Throwable)tme);
        }
        if (parsed.isCacheable()) {
            this._cachedSqlStatements.put(sql, parsed);
        }
        return parsed;
    }
}

