/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.system.jdbc.TypeMappingsFactory;
import org.apache.beehive.controls.system.jdbc.parser.SqlFragment;

public final class ReflectionFragment
extends SqlFragment {
    private static final String PREPARED_STATEMENT_SUB_MARK = "?";
    private static final Pattern s_parameterNamePattern = Pattern.compile("\\.");
    private final String _parameterName;
    private final String[] _nameQualifiers;
    private int _sqlDataType;

    ReflectionFragment(String parameterName) {
        this._parameterName = parameterName;
        this._sqlDataType = 0;
        this._nameQualifiers = s_parameterNamePattern.split(this._parameterName);
    }

    ReflectionFragment(String parameterName, String sqlDataType) {
        this(parameterName);
        if (sqlDataType != null) {
            this._sqlDataType = TypeMappingsFactory.getInstance().convertStringToSQLType(sqlDataType);
        }
    }

    String getPreparedStatementText(ControlBeanContext context, Method m, Object[] args) {
        return PREPARED_STATEMENT_SUB_MARK;
    }

    boolean hasParamValue() {
        return true;
    }

    String getParameterName() {
        return this._parameterName;
    }

    String[] getParameterNameQualifiers() {
        String[] nameQualifiersCopy = new String[this._nameQualifiers.length];
        System.arraycopy(this._nameQualifiers, 0, nameQualifiersCopy, 0, this._nameQualifiers.length);
        return nameQualifiersCopy;
    }

    int getParamSqlDataType() {
        return this._sqlDataType;
    }

    public String toString() {
        return PREPARED_STATEMENT_SUB_MARK;
    }

    Object[] getParameterValues(ControlBeanContext context, Method method, Object[] args) {
        Object value = null;
        try {
            value = context.getParameterValue(method, this._nameQualifiers[0], args);
        }
        catch (IllegalArgumentException iae) {
            throw new ControlException("Invalid argument name in SQL statement: " + this._nameQualifiers[0], (Throwable)iae);
        }
        for (int i = 1; i < this._nameQualifiers.length; ++i) {
            value = this.extractValue(value, this._nameQualifiers[i - 1], this._nameQualifiers[i]);
        }
        return new Object[]{value};
    }

    private Object extractValue(Object aValue, String aName, String bName) {
        Class<?> retType;
        Method getMethod;
        String bNameCapped;
        Object value;
        Class<?> aClass;
        block19: {
            aClass = aValue.getClass();
            value = null;
            bNameCapped = Character.toUpperCase(bName.charAt(0)) + bName.substring(1);
            getMethod = null;
            retType = null;
            try {
                getMethod = aClass.getMethod("is" + bNameCapped, null);
                retType = getMethod.getReturnType();
                if (!retType.equals(Boolean.class) && !retType.equals(Boolean.TYPE)) {
                    getMethod = null;
                    break block19;
                }
                boolean getMethodFound = true;
                try {
                    aClass.getMethod("get" + bNameCapped, null);
                }
                catch (NoSuchMethodException e) {
                    getMethodFound = false;
                }
                if (getMethodFound) {
                    throw new ControlException("Colliding field accsessors in user defined class '" + aClass.getName() + "' for field '" + bName + "'. Please use is<FieldName> for boolean fields and get<FieldName> name for other datatypes.");
                }
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (getMethod == null) {
            try {
                getMethod = aClass.getMethod("get" + bNameCapped, null);
                retType = getMethod.getReturnType();
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (getMethod != null) {
            try {
                value = getMethod.invoke(aValue, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new ControlException("Unable to access public method: " + e.toString());
            }
            catch (InvocationTargetException e) {
                throw new ControlException("Exception thrown when executing : " + getMethod.getName() + "() to use as parameter");
            }
            return value;
        }
        try {
            value = aClass.getField(bName).get(aValue);
            return value;
        }
        catch (NoSuchFieldException e) {
        }
        catch (IllegalAccessException e) {
            // empty catch block
        }
        if (aValue instanceof Map) {
            try {
                value = TypeMappingsFactory.getInstance().lookupType(aValue, new Object[]{bName});
                return value;
            }
            catch (Exception mapex) {
                throw new ControlException("Exception thrown when executing Map.get() to resolve parameter" + mapex.toString());
            }
        }
        throw new ControlException("Illegal argument in SQL statement: " + this._parameterName.toString() + "; unable to find suitable method of retrieving property " + bName.toString() + " out of object " + aName.toString() + ".");
    }
}

