/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc.parser;

import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.ParameterDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.util.DeclarationFilter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.system.jdbc.parser.ReflectionFragment;
import org.apache.beehive.controls.system.jdbc.parser.SqlFragment;
import org.apache.beehive.controls.system.jdbc.parser.SqlFragmentContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterChecker {
    public static void checkReflectionParameters(SqlFragmentContainer statement, MethodDeclaration methodDecl) {
        ArrayList params = new ArrayList(methodDecl.getParameters());
        HashMap<String, ParameterDeclaration> paramMap = new HashMap<String, ParameterDeclaration>();
        if (params.size() > 0 && ((ParameterDeclaration)params.get(0)).getSimpleName().equals("arg0")) {
            return;
        }
        for (int i = 0; i < params.size(); ++i) {
            paramMap.put(((ParameterDeclaration)params.get(i)).getSimpleName(), (ParameterDeclaration)params.get(i));
        }
        ParameterChecker.doCheck(statement, paramMap, methodDecl);
    }

    private static void doCheck(SqlFragmentContainer statement, HashMap<String, ParameterDeclaration> paramMap, MethodDeclaration method) {
        SqlFragment[] fragments;
        for (SqlFragment fragment : fragments = statement.getChildren()) {
            if (fragment instanceof SqlFragmentContainer) {
                ParameterChecker.doCheck((SqlFragmentContainer)fragment, paramMap, method);
                continue;
            }
            if (!(fragment instanceof ReflectionFragment)) continue;
            ParameterChecker.checkReflectionFragment((ReflectionFragment)fragment, paramMap, method);
        }
    }

    private static void checkReflectionFragment(ReflectionFragment fragment, HashMap<String, ParameterDeclaration> paramMap, MethodDeclaration method) {
        String[] paramNameQualifiers = fragment.getParameterNameQualifiers();
        String parameterName = fragment.getParameterName();
        if (!paramMap.containsKey(paramNameQualifiers[0])) {
            throw new ControlException(ParameterChecker.buildMessage(parameterName, method.getSimpleName()));
        }
        ParameterDeclaration tpd = paramMap.get(paramNameQualifiers[0]);
        TypeMirror type = tpd.getType();
        MethodDeclaration getterMethod = null;
        FieldDeclaration field = null;
        for (int i = 1; i < paramNameQualifiers.length; ++i) {
            getterMethod = null;
            field = null;
            while (type != null) {
                if (!(type instanceof DeclaredType)) {
                    throw new ControlException(ParameterChecker.buildMessage(parameterName, method.getSimpleName()));
                }
                TypeDeclaration td = ((DeclaredType)type).getDeclaration();
                if (td.getQualifiedName().equals("java.util.Map")) {
                    return;
                }
                Collection methods = DeclarationFilter.FILTER_PUBLIC.filter(td.getMethods());
                for (MethodDeclaration m : methods) {
                    String upperFirst = paramNameQualifiers[i].substring(0, 1).toUpperCase();
                    if (paramNameQualifiers[i].length() > 1) {
                        upperFirst = upperFirst + paramNameQualifiers[i].substring(1);
                    }
                    if (!m.getSimpleName().equals("get" + upperFirst) && !m.getSimpleName().equals("is" + upperFirst)) continue;
                    getterMethod = m;
                }
                if (getterMethod == null) {
                    Collection fields = DeclarationFilter.FILTER_PUBLIC.filter(td.getFields());
                    for (FieldDeclaration fd : fields) {
                        if (!fd.getSimpleName().equals(paramNameQualifiers[i])) continue;
                        field = fd;
                    }
                }
                if (getterMethod != null || field != null || !(td instanceof ClassDeclaration)) break;
                type = ((ClassDeclaration)td).getSuperclass();
            }
            if (getterMethod != null) {
                type = getterMethod.getReturnType();
                continue;
            }
            if (field != null) {
                type = field.getType();
                continue;
            }
            throw new ControlException(ParameterChecker.buildMessage(parameterName, method.getSimpleName()));
        }
    }

    private static String buildMessage(String parameterName, String methodName) {
        ResourceBundle rb = ResourceBundle.getBundle("org.apache.beehive.controls.system.jdbc.parser.strings", Locale.getDefault());
        String pattern = rb.getString("jdbccontrol.invalid.param");
        return MessageFormat.format(pattern, parameterName, methodName);
    }
}

