/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.beehive.controls.api.ControlException;

public final class TypeMappingsFactory {
    private static TypeMappingsFactory _instance;
    private static Class<?> XMLBEANS_STRING_ENUM_ABSTRACT_BASE;
    public static final int TYPE_UNKNOWN = 0;
    static final int TYPE_BYTE = 1;
    static final int TYPE_SHORT = 2;
    static final int TYPE_INT = 3;
    static final int TYPE_LONG = 4;
    static final int TYPE_FLOAT = 5;
    static final int TYPE_DOUBLE = 6;
    static final int TYPE_BOOLEAN = 7;
    static final int TYPE_BYTE_OBJ = 8;
    static final int TYPE_SHORT_OBJ = 9;
    static final int TYPE_INT_OBJ = 10;
    static final int TYPE_LONG_OBJ = 11;
    static final int TYPE_FLOAT_OBJ = 12;
    static final int TYPE_DOUBLE_OBJ = 13;
    static final int TYPE_BOOLEAN_OBJ = 14;
    static final int TYPE_BIG_DECIMAL = 15;
    static final int TYPE_STRING = 16;
    static final int TYPE_BYTES = 17;
    static final int TYPE_SQLDATE = 18;
    static final int TYPE_TIME = 19;
    static final int TYPE_TIMESTAMP = 20;
    static final int TYPE_STREAM = 21;
    static final int TYPE_READER = 22;
    static final int TYPE_CLOB = 23;
    static final int TYPE_BLOB = 24;
    static final int TYPE_ARRAY = 25;
    static final int TYPE_REF = 26;
    static final int TYPE_DATE = 27;
    static final int TYPE_CALENDAR = 28;
    static final int TYPE_STRUCT = 29;
    static final int TYPE_XMLBEAN_ENUM = 30;
    static final int TYPE_MAX = 31;
    private Map<Class, Object> _primitiveDefaults = new HashMap<Class, Object>();
    private Map<Class, Integer> _typeMap;
    private Map<Class, Integer> _typeSqlMap;
    private Map<String, Integer> _typeSqlNameMap;
    private static Method _methodMapGet;

    public static TypeMappingsFactory getInstance() {
        if (_instance == null) {
            _instance = new TypeMappingsFactory();
        }
        return _instance;
    }

    TypeMappingsFactory() {
        this._primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        this._primitiveDefaults.put(Integer.TYPE, new Integer(0));
        this._primitiveDefaults.put(Long.TYPE, new Long(0L));
        this._primitiveDefaults.put(Byte.TYPE, new Byte(0));
        this._primitiveDefaults.put(Short.TYPE, new Short(0));
        this._primitiveDefaults.put(Character.TYPE, new Character('\u0000'));
        this._primitiveDefaults.put(Float.TYPE, new Float(0.0f));
        this._primitiveDefaults.put(Double.TYPE, new Double(0.0));
        this._typeMap = new HashMap<Class, Integer>(62);
        this._typeMap.put(Boolean.TYPE, new Integer(7));
        this._typeMap.put(Integer.TYPE, new Integer(3));
        this._typeMap.put(Long.TYPE, new Integer(4));
        this._typeMap.put(Byte.TYPE, new Integer(1));
        this._typeMap.put(Short.TYPE, new Integer(2));
        this._typeMap.put(Float.TYPE, new Integer(5));
        this._typeMap.put(Double.TYPE, new Integer(6));
        this._typeMap.put(Boolean.class, new Integer(14));
        this._typeMap.put(Integer.class, new Integer(10));
        this._typeMap.put(Long.class, new Integer(11));
        this._typeMap.put(Byte.class, new Integer(8));
        this._typeMap.put(Short.class, new Integer(9));
        this._typeMap.put(Float.class, new Integer(12));
        this._typeMap.put(Double.class, new Integer(13));
        this._typeMap.put(String.class, new Integer(16));
        this._typeMap.put(BigDecimal.class, new Integer(15));
        this._typeMap.put(byte[].class, new Integer(17));
        this._typeMap.put(Timestamp.class, new Integer(20));
        this._typeMap.put(Time.class, new Integer(19));
        this._typeMap.put(Date.class, new Integer(18));
        this._typeMap.put(Ref.class, new Integer(26));
        this._typeMap.put(Blob.class, new Integer(24));
        this._typeMap.put(Clob.class, new Integer(23));
        this._typeMap.put(Array.class, new Integer(25));
        this._typeMap.put(Struct.class, new Integer(29));
        this._typeMap.put(Reader.class, new Integer(22));
        this._typeMap.put(InputStream.class, new Integer(21));
        this._typeMap.put(java.util.Date.class, new Integer(27));
        this._typeMap.put(Calendar.class, new Integer(28));
        this._typeMap.put(GregorianCalendar.class, new Integer(28));
        if (XMLBEANS_STRING_ENUM_ABSTRACT_BASE != null) {
            this._typeMap.put(XMLBEANS_STRING_ENUM_ABSTRACT_BASE, new Integer(30));
        }
        this._typeSqlMap = new HashMap<Class, Integer>(62);
        this._typeSqlMap.put(Boolean.TYPE, new Integer(16));
        this._typeSqlMap.put(Integer.TYPE, new Integer(4));
        this._typeSqlMap.put(Long.TYPE, new Integer(-5));
        this._typeSqlMap.put(Byte.TYPE, new Integer(-6));
        this._typeSqlMap.put(Short.TYPE, new Integer(5));
        this._typeSqlMap.put(Float.TYPE, new Integer(7));
        this._typeSqlMap.put(Double.TYPE, new Integer(8));
        this._typeSqlMap.put(Boolean.class, new Integer(16));
        this._typeSqlMap.put(Integer.class, new Integer(4));
        this._typeSqlMap.put(Long.class, new Integer(-5));
        this._typeSqlMap.put(Byte.class, new Integer(-6));
        this._typeSqlMap.put(Short.class, new Integer(5));
        this._typeSqlMap.put(Float.class, new Integer(7));
        this._typeSqlMap.put(Double.class, new Integer(8));
        this._typeSqlMap.put(String.class, new Integer(12));
        this._typeSqlMap.put(BigDecimal.class, new Integer(3));
        this._typeSqlMap.put(byte[].class, new Integer(-3));
        this._typeSqlMap.put(Timestamp.class, new Integer(93));
        this._typeSqlMap.put(Time.class, new Integer(92));
        this._typeSqlMap.put(Date.class, new Integer(91));
        this._typeSqlMap.put(Ref.class, new Integer(2006));
        this._typeSqlMap.put(Blob.class, new Integer(2004));
        this._typeSqlMap.put(Clob.class, new Integer(2005));
        this._typeSqlMap.put(Array.class, new Integer(2003));
        this._typeSqlMap.put(Struct.class, new Integer(2002));
        this._typeSqlMap.put(java.util.Date.class, new Integer(93));
        this._typeSqlMap.put(Calendar.class, new Integer(93));
        this._typeSqlMap.put(GregorianCalendar.class, new Integer(93));
        if (XMLBEANS_STRING_ENUM_ABSTRACT_BASE != null) {
            this._typeSqlMap.put(XMLBEANS_STRING_ENUM_ABSTRACT_BASE, new Integer(12));
        }
        this._typeSqlNameMap = new HashMap<String, Integer>(62);
        this._typeSqlNameMap.put("BIT", new Integer(-7));
        this._typeSqlNameMap.put("TINYINT", new Integer(-6));
        this._typeSqlNameMap.put("SMALLINT", new Integer(5));
        this._typeSqlNameMap.put("INTEGER", new Integer(4));
        this._typeSqlNameMap.put("BIGINT", new Integer(-5));
        this._typeSqlNameMap.put("FLOAT", new Integer(7));
        this._typeSqlNameMap.put("REAL", new Integer(7));
        this._typeSqlNameMap.put("DOUBLE", new Integer(8));
        this._typeSqlNameMap.put("NUMERIC", new Integer(2));
        this._typeSqlNameMap.put("DECIMAL", new Integer(3));
        this._typeSqlNameMap.put("CHAR", new Integer(1));
        this._typeSqlNameMap.put("VARCHAR", new Integer(12));
        this._typeSqlNameMap.put("LONGVARCHAR", new Integer(-1));
        this._typeSqlNameMap.put("DATE", new Integer(91));
        this._typeSqlNameMap.put("TIME", new Integer(92));
        this._typeSqlNameMap.put("TIMESTAMP", new Integer(93));
        this._typeSqlNameMap.put("BINARY", new Integer(-2));
        this._typeSqlNameMap.put("VARBINARY", new Integer(-3));
        this._typeSqlNameMap.put("LONGVARBINARY", new Integer(-4));
        this._typeSqlNameMap.put("NULL", new Integer(0));
        this._typeSqlNameMap.put("OTHER", new Integer(1111));
        this._typeSqlNameMap.put("JAVA_OBJECT", new Integer(2000));
        this._typeSqlNameMap.put("DISTINCT", new Integer(2001));
        this._typeSqlNameMap.put("STRUCT", new Integer(2002));
        this._typeSqlNameMap.put("ARRAY", new Integer(2003));
        this._typeSqlNameMap.put("BLOB", new Integer(2004));
        this._typeSqlNameMap.put("CLOB", new Integer(2005));
        this._typeSqlNameMap.put("REF", new Integer(2006));
        this._typeSqlNameMap.put("DATALINK", new Integer(70));
        this._typeSqlNameMap.put("BOOLEAN", new Integer(16));
        this._typeSqlNameMap.put("BYTE", new Integer(-6));
        this._typeSqlNameMap.put("SHORT", new Integer(5));
        this._typeSqlNameMap.put("INT", new Integer(4));
        this._typeSqlNameMap.put("LONG", new Integer(-5));
        try {
            _methodMapGet = Map.class.getMethod("get", Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new ControlException("Can not find java.util.Map.get(Object) method");
        }
    }

    public int convertStringToSQLType(String type) {
        if (this._typeSqlNameMap.containsKey(type.toUpperCase())) {
            return this._typeSqlNameMap.get(type.toUpperCase());
        }
        return 0;
    }

    public int getSqlType(Class classType) {
        Class origType = classType;
        while (classType != null) {
            Integer type = this._typeSqlMap.get(classType);
            if (type != null) {
                return type;
            }
            classType = classType.getSuperclass();
        }
        if (Blob.class.isAssignableFrom(origType)) {
            return this._typeSqlMap.get(Blob.class);
        }
        if (Clob.class.isAssignableFrom(origType)) {
            return this._typeSqlMap.get(Clob.class);
        }
        return 1111;
    }

    public int getSqlType(Object o) {
        if (null == o) {
            return 0;
        }
        return this.getSqlType(o.getClass());
    }

    public Object lookupType(Object val, Object[] args) throws IllegalAccessException, InvocationTargetException {
        return _methodMapGet.invoke(val, args);
    }

    public int getTypeId(Class classType) {
        Class origType = classType;
        while (null != classType) {
            Integer typeObj = this._typeMap.get(classType);
            if (null != typeObj) {
                return typeObj;
            }
            classType = classType.getSuperclass();
        }
        if (Blob.class.isAssignableFrom(origType)) {
            return this._typeMap.get(Blob.class);
        }
        if (Clob.class.isAssignableFrom(origType)) {
            return this._typeMap.get(Clob.class);
        }
        return 0;
    }

    public Object fixNull(Class type) {
        return type.isPrimitive() ? this._primitiveDefaults.get(type) : null;
    }

    public static Object[] toObjectArray(Object o) {
        Object[] arr;
        Class<?> clas = o.getClass().getComponentType();
        if (null == clas) {
            return null;
        }
        if (clas == Boolean.TYPE) {
            boolean[] src = (boolean[])o;
            arr = new Object[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = new Boolean(src[i]);
            }
        } else if (clas == Character.TYPE) {
            char[] src = (char[])o;
            arr = new Object[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = new Character(src[i]);
            }
        } else if (clas == Byte.TYPE) {
            byte[] src = (byte[])o;
            arr = new Object[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = new Byte(src[i]);
            }
        } else if (clas == Short.TYPE) {
            short[] src = (short[])o;
            arr = new Object[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = new Short(src[i]);
            }
        } else if (clas == Integer.TYPE) {
            int[] src = (int[])o;
            arr = new Object[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = new Integer(src[i]);
            }
        } else if (clas == Long.TYPE) {
            long[] src = (long[])o;
            arr = new Object[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = new Long(src[i]);
            }
        } else if (clas == Float.TYPE) {
            float[] src = (float[])o;
            arr = new Object[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = new Float(src[i]);
            }
        } else if (clas == Double.TYPE) {
            double[] src = (double[])o;
            arr = new Object[src.length];
            for (int i = 0; i < src.length; ++i) {
                arr[i] = new Double(src[i]);
            }
        } else {
            arr = (Object[])o;
        }
        return arr;
    }

    static {
        XMLBEANS_STRING_ENUM_ABSTRACT_BASE = null;
        try {
            XMLBEANS_STRING_ENUM_ABSTRACT_BASE = Class.forName("org.apache.xmlbeans.StringEnumAbstractBase");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

