/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.system.jdbc.RowMapper;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;

public class RowToXmlObjectMapper
extends RowMapper {
    private final int _columnCount;
    private final SchemaType _schemaType;
    private SetterMethod[] _setterMethods;
    private final Object[] _args = new Object[1];

    RowToXmlObjectMapper(ResultSet resultSet, Class returnTypeClass, Calendar cal) throws SQLException {
        super(resultSet, returnTypeClass, cal);
        this._columnCount = resultSet.getMetaData().getColumnCount();
        this._schemaType = this.getSchemaType(this._returnTypeClass);
        this._setterMethods = null;
    }

    public Object mapRowToReturnType() {
        XmlObject resultObject = null;
        if (this._columnCount == 1) {
            int typeId = _tmf.getTypeId(this._returnTypeClass);
            try {
                if (typeId != 0) {
                    return this.extractColumnValue(1, typeId);
                }
                Object val = this.extractColumnValue(1, typeId);
                if (this._returnTypeClass.isAssignableFrom(val.getClass())) {
                    return val;
                }
            }
            catch (SQLException e) {
                throw new ControlException(e.getMessage(), (Throwable)e);
            }
        }
        if (this._setterMethods == null) {
            try {
                this.getResultSetMappings();
            }
            catch (SQLException e) {
                throw new ControlException(e.getMessage(), (Throwable)e);
            }
        }
        resultObject = XmlObject.Factory.newInstance((XmlOptions)new XmlOptions().setDocumentType(this._schemaType));
        for (int i = 1; i < this._setterMethods.length; ++i) {
            Method setterMethod = this._setterMethods[i].getSetter();
            Object resultValue = null;
            try {
                resultValue = this.extractColumnValue(i, this._setterMethods[i].getParameterType());
                if (this._setterMethods[i].getParameterType() == 30) {
                    Class parameterClass = this._setterMethods[i].getParameterClass();
                    Method m = parameterClass.getMethod("forString", String.class);
                    resultValue = m.invoke(null, resultValue);
                }
                this._args[0] = resultValue;
                setterMethod.invoke((Object)resultObject, this._args);
                if (this._setterMethods[i].getNilable() == null || !this._resultSet.wasNull()) continue;
                this._setterMethods[i].getNilable().invoke((Object)resultObject, (Object[])null);
                continue;
            }
            catch (SQLException se) {
                throw new ControlException(se.getMessage(), (Throwable)se);
            }
            catch (IllegalArgumentException iae) {
                try {
                    ResultSetMetaData md = this._resultSet.getMetaData();
                    throw new ControlException("The declared Java type for method " + setterMethod.getName() + setterMethod.getParameterTypes()[0].toString() + " is incompatible with the SQL format of column " + md.getColumnName(i).toString() + md.getColumnTypeName(i).toString() + " which returns objects of type " + resultValue.getClass().getName());
                }
                catch (SQLException e) {
                    throw new ControlException(e.getMessage(), (Throwable)e);
                }
            }
            catch (IllegalAccessException e) {
                throw new ControlException("IllegalAccessException when trying to access method " + setterMethod.getName(), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                throw new ControlException("NoSuchMethodException when trying to map schema enum value using Enum.forString().", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                throw new ControlException("IllegalInvocationException when trying to access method " + setterMethod.getName(), (Throwable)e);
            }
        }
        return resultObject;
    }

    private void getResultSetMappings() throws SQLException {
        Method[] classMethods;
        if (this._schemaType.isDocumentType()) {
            return;
        }
        String[] keys = this.getKeysFromResultSet();
        HashMap<String, Method> mapFields = new HashMap<String, Method>(this._columnCount * 2);
        for (int i = 1; i <= this._columnCount; ++i) {
            mapFields.put(keys[i], null);
        }
        for (Method method : classMethods = this._returnTypeClass.getMethods()) {
            String fieldName;
            if (!this.isSetterMethod(method) || !mapFields.containsKey(fieldName = method.getName().substring(3).toUpperCase())) continue;
            mapFields.put(fieldName, method);
        }
        this._setterMethods = new SetterMethod[this._columnCount + 1];
        for (int i = 1; i < this._setterMethods.length; ++i) {
            Method setterMethod = (Method)mapFields.get(keys[i]);
            if (setterMethod == null) {
                throw new ControlException("Unable to map the SQL column " + keys[i] + " to a field on the " + this._returnTypeClass.getName() + " class. Mapping is done using a case insensitive comparision of SQL ResultSet " + "columns to public setter methods on the return class.");
            }
            this._setterMethods[i] = new SetterMethod(setterMethod);
        }
    }

    protected String[] getKeysFromResultSet() throws SQLException {
        String[] keys = super.getKeysFromResultSet();
        SchemaProperty[] props = this._schemaType.getElementProperties();
        for (int i = 0; i < props.length; ++i) {
            int col = -1;
            try {
                col = this._resultSet.findColumn(props[i].getName().getLocalPart());
            }
            catch (SQLException x) {
                // empty catch block
            }
            if (col <= 0) continue;
            keys[col] = props[i].getJavaPropertyName().toUpperCase();
        }
        return keys;
    }

    private SchemaType getSchemaType(Class returnType) {
        SchemaType schemaType = null;
        if (XmlObject.class.isAssignableFrom(returnType)) {
            try {
                Field f = returnType.getField("type");
                if (SchemaType.class.isAssignableFrom(f.getType()) && Modifier.isStatic(f.getModifiers())) {
                    schemaType = (SchemaType)f.get(null);
                }
            }
            catch (NoSuchFieldException x) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return schemaType;
    }

    private final class SetterMethod {
        private final Method _setter;
        private final int _parameterType;
        private final Class _parameterClass;
        private final Method _nilable;

        SetterMethod(Method setter) {
            this._setter = setter;
            this._parameterClass = this._setter.getParameterTypes()[0];
            this._parameterType = RowMapper._tmf.getTypeId(this._parameterClass);
            this._nilable = this.isNilable();
        }

        Method getSetter() {
            return this._setter;
        }

        Class getParameterClass() {
            return this._parameterClass;
        }

        int getParameterType() {
            return this._parameterType;
        }

        Method getNilable() {
            return this._nilable;
        }

        private Method isNilable() {
            try {
                return RowToXmlObjectMapper.this._returnTypeClass.getMethod("setNil" + this._setter.getName().substring(3), new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return null;
            }
        }
    }
}

