/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.system.jdbc.RowMapper;

public class RowToObjectMapper
extends RowMapper {
    private final int _columnCount;
    private AccessibleObject[] _fields = null;
    private int[] _fieldTypes;
    private final Object[] _args = new Object[1];

    RowToObjectMapper(ResultSet resultSet, Class returnTypeClass, Calendar cal) {
        super(resultSet, returnTypeClass, cal);
        try {
            this._columnCount = resultSet.getMetaData().getColumnCount();
        }
        catch (SQLException e) {
            throw new ControlException("RowToObjectMapper: SQLException: " + e.getMessage(), (Throwable)e);
        }
    }

    public Object mapRowToReturnType() {
        Object resultObject = null;
        if (this._columnCount == 1) {
            int typeId = _tmf.getTypeId(this._returnTypeClass);
            try {
                if (typeId != 0) {
                    return this.extractColumnValue(1, typeId);
                }
                Object val = this.extractColumnValue(1, typeId);
                if (this._returnTypeClass.isAssignableFrom(val.getClass())) {
                    return val;
                }
            }
            catch (SQLException e) {
                throw new ControlException(e.getMessage(), (Throwable)e);
            }
        }
        if (this._fields == null) {
            try {
                this.getFieldMappings();
            }
            catch (SQLException e) {
                throw new ControlException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            resultObject = this._returnTypeClass.newInstance();
        }
        catch (InstantiationException e) {
            throw new ControlException("InstantiationException when trying to create instance of : " + this._returnTypeClass.getName(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ControlException("IllegalAccessException when trying to create instance of : " + this._returnTypeClass.getName(), (Throwable)e);
        }
        for (int i = 1; i < this._fields.length; ++i) {
            AccessibleObject f = this._fields[i];
            Object resultValue = null;
            try {
                resultValue = this.extractColumnValue(i, this._fieldTypes[i]);
                if (f instanceof Field) {
                    ((Field)f).set(resultObject, resultValue);
                    continue;
                }
                this._args[0] = resultValue;
                ((Method)f).invoke(resultObject, this._args);
                continue;
            }
            catch (SQLException e) {
                throw new ControlException(e.getMessage(), (Throwable)e);
            }
            catch (IllegalArgumentException iae) {
                try {
                    ResultSetMetaData md = this._resultSet.getMetaData();
                    if (f instanceof Field) {
                        throw new ControlException("The declared Java type for field " + ((Field)f).getName() + ((Field)f).getType().toString() + " is incompatible with the SQL format of column " + md.getColumnName(i).toString() + md.getColumnTypeName(i).toString() + " which returns objects of type " + resultValue.getClass().getName());
                    }
                    throw new ControlException("The declared Java type for method " + ((Method)f).getName() + ((Method)f).getParameterTypes()[0].toString() + " is incompatible with the SQL format of column " + md.getColumnName(i).toString() + md.getColumnTypeName(i).toString() + " which returns objects of type " + resultValue.getClass().getName());
                }
                catch (SQLException e) {
                    throw new ControlException(e.getMessage(), (Throwable)e);
                }
            }
            catch (IllegalAccessException e) {
                if (f instanceof Field) {
                    throw new ControlException("IllegalAccessException when trying to access field " + ((Field)f).getName(), (Throwable)e);
                }
                throw new ControlException("IllegalAccessException when trying to access method " + ((Method)f).getName(), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                if (f instanceof Field) {
                    throw new ControlException("InvocationTargetException when trying to access field " + ((Field)f).getName(), (Throwable)e);
                }
                throw new ControlException("InvocationTargetException when trying to access method " + ((Method)f).getName(), (Throwable)e);
            }
        }
        return resultObject;
    }

    protected void getFieldMappings() throws SQLException {
        Method[] classMethods;
        String[] keys = this.getKeysFromResultSet();
        HashMap<String, AccessibleObject> mapFields = new HashMap<String, AccessibleObject>(this._columnCount * 2);
        for (int i = 1; i <= this._columnCount; ++i) {
            mapFields.put(keys[i], null);
        }
        for (Method m : classMethods = this._returnTypeClass.getMethods()) {
            String fieldName;
            if (!this.isSetterMethod(m) || !mapFields.containsKey(fieldName = m.getName().substring(3).toUpperCase())) continue;
            Object field = mapFields.get(fieldName);
            if (field == null) {
                mapFields.put(fieldName, m);
                continue;
            }
            throw new ControlException("Unable to choose between overloaded methods " + m.getName() + " on the " + this._returnTypeClass.getName() + " class. Mapping is done using " + "a case insensitive comparision of SQL ResultSet columns to field " + "names and public setter methods on the return class.");
        }
        for (Class clazz = this._returnTypeClass; clazz != null && clazz != Object.class; clazz = clazz.getSuperclass()) {
            Field[] classFields;
            for (Field f : classFields = clazz.getDeclaredFields()) {
                Object field;
                String fieldName;
                if (Modifier.isStatic(f.getModifiers()) || !Modifier.isPublic(f.getModifiers()) || !mapFields.containsKey(fieldName = f.getName().toUpperCase()) || (field = mapFields.get(fieldName)) != null) continue;
                mapFields.put(fieldName, f);
            }
        }
        this._fields = new AccessibleObject[this._columnCount + 1];
        this._fieldTypes = new int[this._columnCount + 1];
        for (int i = 1; i < this._fields.length; ++i) {
            AccessibleObject f = (AccessibleObject)mapFields.get(keys[i]);
            if (f == null) {
                throw new ControlException("Unable to map the SQL column " + keys[i] + " to a field on the " + this._returnTypeClass.getName() + " class. Mapping is done using a case insensitive comparision of SQL ResultSet " + "columns to field names and public setter methods on the return class.");
            }
            this._fields[i] = f;
            this._fieldTypes[i] = f instanceof Field ? _tmf.getTypeId(((Field)f).getType()) : _tmf.getTypeId(((Method)f).getParameterTypes()[0]);
        }
    }
}

