/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.system.jdbc.ResultSetHashMap;
import org.apache.beehive.controls.system.jdbc.RowMapper;

public final class RowToMapMapper
extends RowMapper {
    private final String[] _keys;

    RowToMapMapper(ResultSet resultSet, Class returnTypeClass, Calendar cal) {
        super(resultSet, returnTypeClass, cal);
        try {
            this._keys = this.getKeysFromResultSet();
        }
        catch (SQLException e) {
            throw new ControlException("RowToMapMapper: SQLException: " + e.getMessage(), (Throwable)e);
        }
    }

    public Object mapRowToReturnType() {
        try {
            return Collections.unmodifiableMap(new ResultSetHashMap(this._resultSet, this._keys));
        }
        catch (SQLException e) {
            throw new ControlException("Exception while creating ResultSetHashMap.", (Throwable)e);
        }
    }
}

