/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.system.jdbc.ResultSetHashMap;
import org.apache.beehive.controls.system.jdbc.RowMapper;

public final class RowToHashMapMapper
extends RowMapper {
    private final String[] _keys;

    RowToHashMapMapper(ResultSet resultSet, Class returnTypeClass, Calendar cal) {
        super(resultSet, returnTypeClass, cal);
        try {
            this._keys = this.getKeysFromResultSet();
        }
        catch (SQLException sql) {
            throw new ControlException("RowToHashMapMapper: SQLException: " + sql.getMessage(), (Throwable)sql);
        }
    }

    public Object mapRowToReturnType() {
        try {
            return new ResultSetHashMap(this._resultSet, this._keys);
        }
        catch (SQLException e) {
            throw new ControlException("Exception creating HashMap return type: ", (Throwable)e);
        }
    }
}

