/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.system.jdbc.RowMapper;
import org.apache.beehive.controls.system.jdbc.RowToHashMapMapper;
import org.apache.beehive.controls.system.jdbc.RowToMapMapper;
import org.apache.beehive.controls.system.jdbc.RowToObjectMapper;
import org.apache.beehive.controls.system.jdbc.RowToXmlObjectMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RowMapperFactory {
    private static final HashMap<Class, Class<? extends RowMapper>> _rowMappings = new HashMap();
    private static Class<? extends RowMapper> DEFAULT_OBJ_ROWMAPPING = RowToObjectMapper.class;
    private static Class XMLOBJ_CLASS = null;
    private static Class<? extends RowMapper> DEFAULT_XMLOBJ_ROWMAPPING = null;
    private static final Class[] _params = new Class[]{ResultSet.class, Class.class, Calendar.class};

    public static RowMapper getRowMapper(ResultSet rs, Class returnTypeClass, Calendar cal) {
        Class<? extends RowMapper> rm = _rowMappings.get(returnTypeClass);
        if (rm != null) {
            return RowMapperFactory.getMapper(rm, rs, returnTypeClass, cal);
        }
        if (XMLOBJ_CLASS != null && XMLOBJ_CLASS.isAssignableFrom(returnTypeClass)) {
            return RowMapperFactory.getMapper(DEFAULT_XMLOBJ_ROWMAPPING, rs, returnTypeClass, cal);
        }
        return RowMapperFactory.getMapper(DEFAULT_OBJ_ROWMAPPING, rs, returnTypeClass, cal);
    }

    public static void addRowMapping(Class returnTypeClass, Class<? extends RowMapper> rowMapperClass) {
        _rowMappings.put(returnTypeClass, rowMapperClass);
    }

    public static Class<? extends RowMapper> replaceRowMapping(Class returnTypeClass, Class<? extends RowMapper> rowMapperClass) {
        return _rowMappings.put(returnTypeClass, rowMapperClass);
    }

    public static Class<? extends RowMapper> removeRowMapping(Class returnTypeClass) {
        return _rowMappings.remove(returnTypeClass);
    }

    public static Class<? extends RowMapper> setDefaultRowMapping(Class<? extends RowMapper> rowMapperClass) {
        Class<? extends RowMapper> ret = DEFAULT_OBJ_ROWMAPPING;
        DEFAULT_OBJ_ROWMAPPING = rowMapperClass;
        return ret;
    }

    public static Class<? extends RowMapper> setDefaultXmlRowMapping(Class mapToClass, Class<? extends RowMapper> rowMapperClass) {
        Class<? extends RowMapper> ret = DEFAULT_XMLOBJ_ROWMAPPING;
        DEFAULT_XMLOBJ_ROWMAPPING = rowMapperClass;
        XMLOBJ_CLASS = mapToClass;
        return ret;
    }

    private static RowMapper getMapper(Class<? extends RowMapper> rowMapper, ResultSet rs, Class returnType, Calendar cal) {
        Constructor<? extends RowMapper> c = null;
        try {
            c = rowMapper.getDeclaredConstructor(_params);
            return c.newInstance(rs, returnType, cal);
        }
        catch (NoSuchMethodException e) {
            throw new ControlException("Failure creating new instance of RowMapper, " + e.toString(), (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new ControlException("Failure creating new instance of RowMapper, " + e.toString(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new ControlException("Failure creating new instance of RowMapper, " + e.toString(), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new ControlException("Failure creating new instance of RowMapper, " + e.getCause().toString(), (Throwable)e);
        }
    }

    static {
        _rowMappings.put(HashMap.class, RowToHashMapMapper.class);
        _rowMappings.put(Map.class, RowToMapMapper.class);
        try {
            XMLOBJ_CLASS = Class.forName("org.apache.xmlbeans.XmlObject");
            DEFAULT_XMLOBJ_ROWMAPPING = RowToXmlObjectMapper.class;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

