/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.system.jdbc.TypeMappingsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RowMapper {
    private static final String SETTER_NAME_REGEX = "^(set)([A-Z_]\\w*+)";
    protected static final TypeMappingsFactory _tmf = TypeMappingsFactory.getInstance();
    protected static final Pattern _setterRegex = Pattern.compile("^(set)([A-Z_]\\w*+)");
    protected final ResultSet _resultSet;
    protected final Calendar _cal;
    protected final Class<?> _returnTypeClass;

    protected RowMapper(ResultSet resultSet, Class<?> returnTypeClass, Calendar cal) {
        this._resultSet = resultSet;
        this._returnTypeClass = returnTypeClass;
        this._cal = cal;
    }

    public abstract Object mapRowToReturnType();

    protected String[] getKeysFromResultSet() throws SQLException {
        ResultSetMetaData md = this._resultSet.getMetaData();
        int columnCount = md.getColumnCount();
        String[] keys = new String[columnCount + 1];
        for (int i = 1; i <= columnCount; ++i) {
            keys[i] = md.getColumnName(i).toUpperCase();
        }
        return keys;
    }

    protected boolean isSetterMethod(Method method) {
        Matcher matcher = _setterRegex.matcher(method.getName());
        if (matcher.matches()) {
            if (Modifier.isStatic(method.getModifiers())) {
                return false;
            }
            if (!Modifier.isPublic(method.getModifiers())) {
                return false;
            }
            if (!Void.TYPE.equals(method.getReturnType())) {
                return false;
            }
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 1) {
                return false;
            }
            return 0 != _tmf.getTypeId(params[0]);
        }
        return false;
    }

    protected Object extractColumnValue(int index, int resultType) throws SQLException {
        switch (resultType) {
            case 3: {
                return new Integer(this._resultSet.getInt(index));
            }
            case 4: {
                return new Long(this._resultSet.getLong(index));
            }
            case 5: {
                return new Float(this._resultSet.getFloat(index));
            }
            case 6: {
                return new Double(this._resultSet.getDouble(index));
            }
            case 1: {
                return new Byte(this._resultSet.getByte(index));
            }
            case 2: {
                return new Short(this._resultSet.getShort(index));
            }
            case 7: {
                return this._resultSet.getBoolean(index) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 10: {
                int i = this._resultSet.getInt(index);
                return this._resultSet.wasNull() ? null : new Integer(i);
            }
            case 11: {
                long i = this._resultSet.getLong(index);
                return this._resultSet.wasNull() ? null : new Long(i);
            }
            case 12: {
                float i = this._resultSet.getFloat(index);
                return this._resultSet.wasNull() ? null : new Float(i);
            }
            case 13: {
                double i = this._resultSet.getDouble(index);
                return this._resultSet.wasNull() ? null : new Double(i);
            }
            case 8: {
                byte i = this._resultSet.getByte(index);
                return this._resultSet.wasNull() ? null : new Byte(i);
            }
            case 9: {
                short i = this._resultSet.getShort(index);
                return this._resultSet.wasNull() ? null : new Short(i);
            }
            case 14: {
                boolean i = this._resultSet.getBoolean(index);
                return this._resultSet.wasNull() ? null : (i ? Boolean.TRUE : Boolean.FALSE);
            }
            case 16: 
            case 30: {
                return this._resultSet.getString(index);
            }
            case 15: {
                return this._resultSet.getBigDecimal(index);
            }
            case 17: {
                return this._resultSet.getBytes(index);
            }
            case 20: {
                if (null == this._cal) {
                    return this._resultSet.getTimestamp(index);
                }
                return this._resultSet.getTimestamp(index, this._cal);
            }
            case 19: {
                if (null == this._cal) {
                    return this._resultSet.getTime(index);
                }
                return this._resultSet.getTime(index, this._cal);
            }
            case 18: {
                if (null == this._cal) {
                    return this._resultSet.getDate(index);
                }
                return this._resultSet.getDate(index, this._cal);
            }
            case 27: {
                Timestamp ts;
                Timestamp timestamp = ts = null == this._cal ? this._resultSet.getTimestamp(index) : this._resultSet.getTimestamp(index, this._cal);
                if (null == ts) {
                    return null;
                }
                return new Date(ts.getTime());
            }
            case 28: {
                Timestamp ts;
                Timestamp timestamp = ts = null == this._cal ? this._resultSet.getTimestamp(index) : this._resultSet.getTimestamp(index, this._cal);
                if (null == ts) {
                    return null;
                }
                Calendar c = null == this._cal ? Calendar.getInstance() : (Calendar)this._cal.clone();
                c.setTimeInMillis(ts.getTime());
                return c;
            }
            case 26: {
                return this._resultSet.getRef(index);
            }
            case 24: {
                return this._resultSet.getBlob(index);
            }
            case 23: {
                return this._resultSet.getClob(index);
            }
            case 25: {
                return this._resultSet.getArray(index);
            }
            case 21: 
            case 22: {
                throw new ControlException("streaming return types are not supported by the JdbcControl; use ResultSet instead");
            }
            case 0: 
            case 29: {
                return this._resultSet.getObject(index);
            }
        }
        throw new ControlException("internal error: unknown type ID: " + Integer.toString(resultType));
    }
}

