/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.system.jdbc.JdbcControl;
import org.apache.beehive.controls.system.jdbc.RowMapper;
import org.apache.beehive.controls.system.jdbc.RowMapperFactory;

public class ResultSetIterator
implements Iterator {
    private final Class _returnClass;
    private final ResultSet _rs;
    private final RowMapper _rowMapper;
    private boolean _primed = false;

    ResultSetIterator(ControlBeanContext context, Method method, ResultSet rs, Calendar cal) {
        this._rs = rs;
        JdbcControl.SQL methodSQL = (JdbcControl.SQL)context.getMethodPropertySet(method, JdbcControl.SQL.class);
        this._returnClass = methodSQL.iteratorElementType();
        if (this._returnClass == null) {
            throw new ControlException("Invalid return class declared for Iterator:" + this._returnClass.getName());
        }
        this._rowMapper = RowMapperFactory.getRowMapper(rs, this._returnClass, cal);
    }

    public boolean hasNext() {
        if (this._primed) {
            return true;
        }
        try {
            this._primed = this._rs.next();
        }
        catch (SQLException sqle) {
            return false;
        }
        return this._primed;
    }

    public Object next() {
        try {
            if (!this._primed) {
                this._primed = this._rs.next();
                if (!this._primed) {
                    throw new NoSuchElementException();
                }
            }
            this._primed = false;
            return this._rowMapper.mapRowToReturnType();
        }
        catch (SQLException e) {
            NoSuchElementException xNoSuch = new NoSuchElementException("ResultSet exception: " + e);
            xNoSuch.initCause(e);
            throw xNoSuch;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException("remove not supported");
    }
}

