/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.bean.ControlImplementation;
import org.apache.beehive.controls.api.bean.Extensible;
import org.apache.beehive.controls.api.context.Context;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.api.context.ResourceContext;
import org.apache.beehive.controls.api.events.EventHandler;
import org.apache.beehive.controls.system.jdbc.DefaultIteratorResultSetMapper;
import org.apache.beehive.controls.system.jdbc.DefaultObjectResultSetMapper;
import org.apache.beehive.controls.system.jdbc.DefaultResultSetMapper;
import org.apache.beehive.controls.system.jdbc.DefaultXmlObjectResultSetMapper;
import org.apache.beehive.controls.system.jdbc.JdbcControl;
import org.apache.beehive.controls.system.jdbc.ResultSetMapper;
import org.apache.beehive.controls.system.jdbc.parser.SqlParser;
import org.apache.beehive.controls.system.jdbc.parser.SqlStatement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ControlImplementation
public class JdbcControlImpl
implements JdbcControl,
Extensible,
Serializable {
    @Context
    protected ControlBeanContext _context;
    @Context
    protected ResourceContext _resourceContext;
    protected transient Connection _connection;
    protected transient JdbcControl.ConnectionDataSource _connectionDataSource;
    protected transient DataSource _dataSource;
    protected transient JdbcControl.ConnectionDriver _connectionDriver;
    private Calendar _cal;
    private transient Vector<PreparedStatement> _resources;
    private static final String EMPTY_STRING = "";
    private static final Log LOGGER = LogFactory.getLog(JdbcControlImpl.class);
    private static final ResultSetMapper DEFAULT_MAPPER = new DefaultObjectResultSetMapper();
    private static final SqlParser _sqlParser = new SqlParser();
    protected static final HashMap<Class, ResultSetMapper> _resultMappers = new HashMap();
    protected static Class<?> _xmlObjectClass;

    @EventHandler(field="_resourceContext", eventSet=ResourceContext.ResourceEvents.class, eventName="onAcquire")
    public void onAquire() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Enter: onAquire()");
        }
        try {
            this.getConnection();
        }
        catch (SQLException se) {
            throw new ControlException("SQL Exception while attempting to connect to database.", (Throwable)se);
        }
    }

    @EventHandler(field="_resourceContext", eventSet=ResourceContext.ResourceEvents.class, eventName="onRelease")
    public void onRelease() {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Enter: onRelease()");
        }
        for (PreparedStatement ps : this.getResources()) {
            try {
                ps.close();
            }
            catch (SQLException sQLException) {}
        }
        this.getResources().clear();
        if (this._connection != null) {
            try {
                this._connection.close();
            }
            catch (SQLException e) {
                throw new ControlException("SQL Exception while attempting to close database connection.", (Throwable)e);
            }
        }
        this._connection = null;
        this._connectionDataSource = null;
        this._connectionDriver = null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this._connection == null) {
            this._connectionDataSource = (JdbcControl.ConnectionDataSource)this._context.getControlPropertySet(JdbcControl.ConnectionDataSource.class);
            this._connectionDriver = (JdbcControl.ConnectionDriver)this._context.getControlPropertySet(JdbcControl.ConnectionDriver.class);
            JdbcControl.ConnectionOptions connectionOptions = (JdbcControl.ConnectionOptions)this._context.getControlPropertySet(JdbcControl.ConnectionOptions.class);
            if (this._connectionDataSource != null && this._connectionDataSource.jndiName() != null) {
                this._connection = this.getConnectionFromDataSource(this._connectionDataSource.jndiName(), this._connectionDataSource.jndiContextFactory());
            } else if (this._connectionDriver != null && this._connectionDriver.databaseDriverClass() != null) {
                this._connection = this.getConnectionFromDriverManager(this._connectionDriver.databaseDriverClass(), this._connectionDriver.databaseURL(), this._connectionDriver.userName(), this._connectionDriver.password(), this._connectionDriver.properties());
            } else {
                throw new ControlException("no @'" + JdbcControl.ConnectionDataSource.class.getName() + "' or '" + JdbcControl.ConnectionDriver.class.getName() + "' property found.");
            }
            if (connectionOptions != null) {
                if (this._connection.isReadOnly() != connectionOptions.readOnly()) {
                    this._connection.setReadOnly(connectionOptions.readOnly());
                }
                DatabaseMetaData dbMetadata = this._connection.getMetaData();
                JdbcControl.HoldabilityType holdability = connectionOptions.resultSetHoldability();
                if (holdability != JdbcControl.HoldabilityType.DRIVER_DEFAULT) {
                    if (dbMetadata.supportsResultSetHoldability(holdability.getHoldability())) {
                        this._connection.setHoldability(holdability.getHoldability());
                    } else {
                        throw new ControlException("Database does not support ResultSet holdability type: " + holdability.toString());
                    }
                }
                this.setTypeMappers(connectionOptions.typeMappers());
            }
        }
        return this._connection;
    }

    public Object invoke(Method method, Object[] args) throws Throwable {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Enter: invoke()");
        }
        assert (!this._connection.isClosed()) : "invoke(): JDBC Connection has been closed!!!!";
        return this.execPreparedStatement(method, args);
    }

    @Override
    public void setDataSourceCalendar(Calendar cal) {
        this._cal = (Calendar)cal.clone();
    }

    @Override
    public Calendar getDataSourceCalendar() {
        return this._cal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Object execPreparedStatement(Method method, Object[] args) throws Throwable {
        JdbcControl.SQL methodSQL = (JdbcControl.SQL)this._context.getMethodPropertySet(method, JdbcControl.SQL.class);
        if (methodSQL == null || methodSQL.statement() == null) {
            throw new ControlException("Method " + method.getName() + " is missing @SQL annotation");
        }
        this.setTypeMappers(methodSQL.typeMappersOverride());
        Statement ps = null;
        try {
            Class<?> returnType = method.getReturnType();
            SqlStatement sqlStatement = _sqlParser.parse(methodSQL.statement());
            ps = sqlStatement.createPreparedStatement(this._context, this._connection, this._cal, method, args);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info((Object)("PreparedStatement: " + sqlStatement.createPreparedStatementString(this._context, this._connection, method, args)));
            }
            if (sqlStatement.isBatchUpdate()) {
                int[] nArray = ps.executeBatch();
                return nArray;
            }
            boolean hasResults = ps.execute();
            if (sqlStatement.isCallableStatement()) {
                JdbcControl.SQLParameter[] params = (JdbcControl.SQLParameter[])args[0];
                for (int i = 0; i < params.length; ++i) {
                    if (params[i].dir == 1) continue;
                    params[i].value = ((CallableStatement)ps).getObject(i + 1);
                }
                Object i = null;
                return i;
            }
            ResultSet rs = null;
            int updateCount = ps.getUpdateCount();
            if (hasResults) {
                rs = ps.getResultSet();
            }
            if (sqlStatement.getsGeneratedKeys()) {
                rs = ps.getGeneratedKeys();
                hasResults = true;
            }
            if (!hasResults && updateCount > -1) {
                boolean moreResults = ps.getMoreResults();
                int tempUpdateCount = ps.getUpdateCount();
                while (moreResults && rs == null || tempUpdateCount > -1) {
                    if (moreResults) {
                        rs = ps.getResultSet();
                        hasResults = true;
                        moreResults = false;
                        tempUpdateCount = -1;
                        continue;
                    }
                    moreResults = ps.getMoreResults();
                    tempUpdateCount = ps.getUpdateCount();
                }
            }
            Object returnObject = null;
            if (hasResults) {
                ResultSetMapper rsm;
                Class resultSetMapperClass = methodSQL.resultSetMapper();
                if (!JdbcControl.UndefinedResultSetMapper.class.isAssignableFrom(resultSetMapperClass)) {
                    if (!ResultSetMapper.class.isAssignableFrom(resultSetMapperClass)) throw new ControlException("Result set mappers must be subclasses of ResultSetMapper.class!");
                    rsm = (ResultSetMapper)resultSetMapperClass.newInstance();
                } else {
                    rsm = _resultMappers.containsKey(returnType) ? _resultMappers.get(returnType) : (_xmlObjectClass != null && _xmlObjectClass.isAssignableFrom(returnType) ? _resultMappers.get(_xmlObjectClass) : DEFAULT_MAPPER);
                }
                returnObject = rsm.mapToResultType(this._context, method, rs, this._cal);
                if (!rsm.canCloseResultSet()) {
                    this.getResources().add((PreparedStatement)ps);
                }
            } else if (returnType.equals(Void.TYPE)) {
                returnObject = null;
            } else if (returnType.equals(Integer.TYPE)) {
                returnObject = new Integer(updateCount);
            } else if (!sqlStatement.isCallableStatement()) {
                throw new ControlException("Method " + method.getName() + "is DML but does not return void or int");
            }
            Integer n = returnObject;
            return n;
        }
        finally {
            if (ps != null && !this.getResources().contains(ps)) {
                ps.close();
            }
        }
    }

    private Connection getConnectionFromDataSource(String jndiName, Class<? extends JdbcControl.JndiContextFactory> jndiFactory) throws SQLException {
        Connection con = null;
        try {
            JdbcControl.JndiContextFactory jf = jndiFactory.newInstance();
            javax.naming.Context jndiContext = jf.getContext();
            this._dataSource = (DataSource)jndiContext.lookup(jndiName);
            con = this._dataSource.getConnection();
        }
        catch (IllegalAccessException iae) {
            throw new ControlException("IllegalAccessException:", (Throwable)iae);
        }
        catch (InstantiationException ie) {
            throw new ControlException("InstantiationException:", (Throwable)ie);
        }
        catch (NamingException ne) {
            throw new ControlException("NamingException:", (Throwable)ne);
        }
        return con;
    }

    private Connection getConnectionFromDriverManager(String dbDriverClassName, String dbUrlStr, String userName, String password, String propertiesString) throws SQLException {
        Connection con = null;
        try {
            Class.forName(dbDriverClassName);
            if (!EMPTY_STRING.equals(userName)) {
                con = DriverManager.getConnection(dbUrlStr, userName, password);
            } else if (!EMPTY_STRING.equals(propertiesString)) {
                Properties props = this.parseProperties(propertiesString);
                if (props == null) {
                    throw new ControlException("Invalid properties annotation value: " + propertiesString);
                }
                con = DriverManager.getConnection(dbUrlStr, props);
            } else {
                con = DriverManager.getConnection(dbUrlStr);
            }
        }
        catch (ClassNotFoundException e) {
            throw new ControlException("Database driver class not found!", (Throwable)e);
        }
        return con;
    }

    private Vector<PreparedStatement> getResources() {
        if (this._resources == null) {
            this._resources = new Vector();
        }
        return this._resources;
    }

    private Properties parseProperties(String propertiesString) {
        Properties properties = null;
        String[] propPairs = propertiesString.split(";");
        if (propPairs.length > 0) {
            properties = new Properties();
            for (String propPair : propPairs) {
                int eq = propPair.indexOf(61);
                assert (eq > -1) : "Invalid properties syntax: " + propertiesString;
                properties.put(propPair.substring(0, eq), propPair.substring(eq + 1, propPair.length()));
            }
        }
        return properties;
    }

    private void setTypeMappers(JdbcControl.TypeMapper[] typeMappers) throws SQLException {
        if (typeMappers.length > 0) {
            Map<String, Class<?>> mappers = this._connection.getTypeMap();
            for (JdbcControl.TypeMapper t : typeMappers) {
                mappers.put(t.UDTName(), t.mapperClass());
            }
            this._connection.setTypeMap(mappers);
        }
    }

    static {
        _resultMappers.put(ResultSet.class, new DefaultResultSetMapper());
        _resultMappers.put(Iterator.class, new DefaultIteratorResultSetMapper());
        try {
            _xmlObjectClass = Class.forName("org.apache.xmlbeans.XmlObject");
            _resultMappers.put(_xmlObjectClass, new DefaultXmlObjectResultSetMapper());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

