/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.mirror.type.ArrayType;
import com.sun.mirror.type.DeclaredType;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.type.MirroredTypeException;
import com.sun.mirror.type.PrimitiveType;
import com.sun.mirror.type.TypeMirror;
import com.sun.mirror.type.VoidType;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.bean.ControlChecker;
import org.apache.beehive.controls.system.jdbc.JdbcControl;
import org.apache.beehive.controls.system.jdbc.parser.ParameterChecker;
import org.apache.beehive.controls.system.jdbc.parser.SqlParser;
import org.apache.beehive.controls.system.jdbc.parser.SqlStatement;

public class JdbcControlChecker
implements ControlChecker {
    private Locale _locale;

    public void check(Declaration decl, AnnotationProcessorEnvironment env) {
        this._locale = Locale.getDefault();
        if (decl instanceof TypeDeclaration) {
            Collection methods = ((TypeDeclaration)decl).getMethods();
            for (MethodDeclaration method : methods) {
                this.checkSQL(method, env);
            }
        } else if (decl instanceof FieldDeclaration) {
            // empty if block
        }
    }

    private void checkSQL(MethodDeclaration method, AnnotationProcessorEnvironment env) {
        String iName;
        SqlStatement _statement;
        JdbcControl.SQL methodSQL = (JdbcControl.SQL)method.getAnnotation(JdbcControl.SQL.class);
        if (methodSQL == null) {
            return;
        }
        if (methodSQL.statement() == null || methodSQL.statement().length() == 0) {
            env.getMessager().printError(method.getPosition(), this.getResourceString("jdbccontrol.empty.statement", method.getSimpleName()));
            return;
        }
        int maxRows = methodSQL.maxRows();
        if (maxRows < 0) {
            env.getMessager().printError(method.getPosition(), this.getResourceString("jdbccontrol.bad.maxrows", method.getSimpleName(), maxRows));
            return;
        }
        int arrayMax = methodSQL.arrayMaxLength();
        if (arrayMax < 1) {
            env.getMessager().printError(method.getPosition(), this.getResourceString("jdbccontrol.bad.arraymaxlength", method.getSimpleName(), arrayMax));
            return;
        }
        SqlParser _p = new SqlParser();
        try {
            _statement = _p.parse(methodSQL.statement());
        }
        catch (ControlException ce) {
            env.getMessager().printError(method.getPosition(), this.getResourceString("jdbccontrol.bad.parse", method.getSimpleName(), ce.toString()));
            return;
        }
        try {
            ParameterChecker.checkReflectionParameters(_statement, method);
        }
        catch (ControlException e) {
            env.getMessager().printError(method.getPosition(), e.getMessage());
            return;
        }
        boolean getGeneratedKeys = methodSQL.getGeneratedKeys();
        String[] generatedKeyColumnNames = methodSQL.generatedKeyColumnNames();
        int[] generatedKeyIndexes = methodSQL.generatedKeyColumnIndexes();
        if (!(getGeneratedKeys || generatedKeyColumnNames.length == 0 && generatedKeyIndexes.length == 0)) {
            env.getMessager().printError(method.getPosition(), this.getResourceString("jdbccontrol.genkeys", method.getSimpleName()));
            return;
        }
        if (generatedKeyColumnNames.length > 0 && generatedKeyIndexes.length > 0) {
            env.getMessager().printError(method.getPosition(), this.getResourceString("jdbccontrol.genkeycolumns", method.getSimpleName()));
            return;
        }
        boolean batchUpdate = methodSQL.batchUpdate();
        TypeMirror returnType = method.getReturnType();
        if (batchUpdate) {
            if (returnType instanceof ArrayType) {
                TypeMirror aType = ((ArrayType)returnType).getComponentType();
                if (!(aType instanceof PrimitiveType) || ((PrimitiveType)aType).getKind() != PrimitiveType.Kind.INT) {
                    env.getMessager().printError(method.getPosition(), this.getResourceString("jdbccontrol.batchupdate", method.getSimpleName()));
                    return;
                }
            } else if (!(returnType instanceof VoidType)) {
                env.getMessager().printError(method.getPosition(), this.getResourceString("jdbccontrol.batchupdate", method.getSimpleName()));
                return;
            }
        }
        if (returnType instanceof InterfaceType && "java.util.Iterator".equals(iName = ((InterfaceType)returnType).getDeclaration().getQualifiedName())) {
            String iteratorClassName = null;
            try {
                methodSQL.iteratorElementType();
            }
            catch (MirroredTypeException mte) {
                iteratorClassName = mte.getQualifiedName();
            }
            if ("org.apache.beehive.controls.system.jdbc.JdbcControl.UndefinedIteratorType".equals(iteratorClassName)) {
                env.getMessager().printError(method.getPosition(), this.getResourceString("jdbccontrol.iterator.returntype", method.getSimpleName()));
                return;
            }
        }
        JdbcControl.ScrollType scrollable = methodSQL.scrollableResultSet();
        switch (scrollable) {
            case SCROLL_INSENSITIVE: 
            case SCROLL_SENSITIVE: 
            case SCROLL_INSENSITIVE_UPDATABLE: 
            case SCROLL_SENSITIVE_UPDATABLE: 
            case FORWARD_ONLY_UPDATABLE: {
                String typeName = null;
                if (returnType instanceof DeclaredType) {
                    typeName = ((DeclaredType)returnType).getDeclaration().getQualifiedName();
                }
                if (typeName != null && "java.sql.ResultSet".equals(typeName)) break;
                env.getMessager().printError(method.getPosition(), this.getResourceString("jdbccontrol.scrollresultset", method.getSimpleName()));
                return;
            }
        }
    }

    private String getResourceString(String id, Object ... args) {
        ResourceBundle rb = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".strings", this._locale);
        String pattern = rb.getString(id);
        return MessageFormat.format(pattern, args);
    }
}

