/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.api.properties.BaseProperties;
import org.apache.beehive.controls.api.properties.PropertyKey;
import org.apache.beehive.controls.api.properties.PropertyMap;
import org.apache.beehive.controls.runtime.bean.ControlBean;
import org.apache.beehive.controls.system.jdbc.JdbcControl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcControlBean
extends ControlBean
implements JdbcControl {
    static final Method _getConnectionMethod;
    static final Method _setDataSourceCalendarMethod;
    static final Method _getDataSourceCalendarMethod;
    static HashMap<Method, String[]> _methodParamMap;
    public static final PropertyKey ControlImplementationKey;
    public static final PropertyKey ConnectionDataSourceJndiNameKey;
    public static final PropertyKey ConnectionDataSourceJndiContextFactoryKey;
    public static final PropertyKey ConnectionDriverDatabaseDriverClassKey;
    public static final PropertyKey ConnectionDriverDatabaseURLKey;
    public static final PropertyKey ConnectionDriverUserNameKey;
    public static final PropertyKey ConnectionDriverPasswordKey;
    public static final PropertyKey ConnectionDriverPropertiesKey;
    public static final PropertyKey ConnectionOptionsReadOnlyKey;
    public static final PropertyKey ConnectionOptionsResultSetHoldabilityKey;
    public static final PropertyKey ConnectionOptionsTypeMappersKey;
    public static final PropertyKey TypeMapperUDTNameKey;
    public static final PropertyKey TypeMapperMapperClassKey;
    public static final PropertyKey SQLStatementKey;
    public static final PropertyKey SQLArrayMaxLengthKey;
    public static final PropertyKey SQLMaxRowsKey;
    public static final PropertyKey SQLBatchUpdateKey;
    public static final PropertyKey SQLFetchSizeKey;
    public static final PropertyKey SQLFetchDirectionKey;
    public static final PropertyKey SQLGetGeneratedKeysKey;
    public static final PropertyKey SQLGeneratedKeyColumnNamesKey;
    public static final PropertyKey SQLGeneratedKeyColumnIndexesKey;
    public static final PropertyKey SQLResultSetHoldabilityOverrideKey;
    public static final PropertyKey SQLTypeMappersOverrideKey;
    public static final PropertyKey SQLIteratorElementTypeKey;
    public static final PropertyKey SQLResultSetMapperKey;
    public static final PropertyKey SQLScrollableResultSetKey;
    private static HashMap _annotCache;
    private static final long serialVersionUID = 1L;

    public JdbcControlBean(ControlBeanContext context, String id, PropertyMap props) {
        this(context, id, props, JdbcControl.class);
    }

    public JdbcControlBean() {
        this(null, null, null);
    }

    protected JdbcControlBean(ControlBeanContext context, String id, PropertyMap props, Class controlClass) {
        super(context, id, props, controlClass);
    }

    protected String[] getParameterNames(Method m) {
        if (_methodParamMap.containsKey(m)) {
            return _methodParamMap.get(m);
        }
        return super.getParameterNames(m);
    }

    @Override
    public Connection getConnection() throws SQLException {
        Object[] argArray = new Object[]{};
        Throwable thrown = null;
        JdbcControl target = (JdbcControl)this.ensureControl();
        Connection retval = null;
        try {
            this.preInvoke(_getConnectionMethod, argArray);
            retval = target.getConnection();
        }
        catch (Throwable t) {
            thrown = t;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof SQLException) {
                throw (SQLException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        finally {
            Connection rv = retval;
            this.postInvoke(_getConnectionMethod, argArray, rv, thrown);
        }
        return retval;
    }

    @Override
    public void setDataSourceCalendar(Calendar cal) {
        Object[] argArray = new Object[]{cal};
        Throwable thrown = null;
        JdbcControl target = (JdbcControl)this.ensureControl();
        try {
            this.preInvoke(_setDataSourceCalendarMethod, argArray);
            target.setDataSourceCalendar(cal);
        }
        catch (Throwable t) {
            thrown = t;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        finally {
            Object rv = null;
            this.postInvoke(_setDataSourceCalendarMethod, argArray, rv, thrown);
        }
    }

    @Override
    public Calendar getDataSourceCalendar() {
        Object[] argArray = new Object[]{};
        Throwable thrown = null;
        JdbcControl target = (JdbcControl)this.ensureControl();
        Calendar retval = null;
        try {
            this.preInvoke(_getDataSourceCalendarMethod, argArray);
            retval = target.getDataSourceCalendar();
        }
        catch (Throwable t) {
            thrown = t;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        finally {
            Calendar rv = retval;
            this.postInvoke(_getDataSourceCalendarMethod, argArray, rv, thrown);
        }
        return retval;
    }

    public synchronized void setControlImplementation(String value) {
        this.setControlProperty(ControlImplementationKey, value);
    }

    public String getControlImplementation() {
        return (String)this.getControlProperty(ControlImplementationKey);
    }

    public synchronized void setConnectionDataSourceJndiName(String value) {
        this.setControlProperty(ConnectionDataSourceJndiNameKey, value);
    }

    public String getConnectionDataSourceJndiName() {
        return (String)this.getControlProperty(ConnectionDataSourceJndiNameKey);
    }

    public synchronized void setConnectionDataSourceJndiContextFactory(Class<? extends JdbcControl.JndiContextFactory> value) {
        this.setControlProperty(ConnectionDataSourceJndiContextFactoryKey, value);
    }

    public Class<? extends JdbcControl.JndiContextFactory> getConnectionDataSourceJndiContextFactory() {
        return (Class)this.getControlProperty(ConnectionDataSourceJndiContextFactoryKey);
    }

    public synchronized void setConnectionDriverDatabaseDriverClass(String value) {
        this.setControlProperty(ConnectionDriverDatabaseDriverClassKey, value);
    }

    public String getConnectionDriverDatabaseDriverClass() {
        return (String)this.getControlProperty(ConnectionDriverDatabaseDriverClassKey);
    }

    public synchronized void setConnectionDriverDatabaseURL(String value) {
        this.setControlProperty(ConnectionDriverDatabaseURLKey, value);
    }

    public String getConnectionDriverDatabaseURL() {
        return (String)this.getControlProperty(ConnectionDriverDatabaseURLKey);
    }

    public synchronized void setConnectionDriverUserName(String value) {
        this.setControlProperty(ConnectionDriverUserNameKey, value);
    }

    public String getConnectionDriverUserName() {
        return (String)this.getControlProperty(ConnectionDriverUserNameKey);
    }

    public synchronized void setConnectionDriverPassword(String value) {
        this.setControlProperty(ConnectionDriverPasswordKey, value);
    }

    public String getConnectionDriverPassword() {
        return (String)this.getControlProperty(ConnectionDriverPasswordKey);
    }

    public synchronized void setConnectionDriverProperties(String value) {
        this.setControlProperty(ConnectionDriverPropertiesKey, value);
    }

    public String getConnectionDriverProperties() {
        return (String)this.getControlProperty(ConnectionDriverPropertiesKey);
    }

    public synchronized void setConnectionOptionsReadOnly(boolean value) {
        this.setControlProperty(ConnectionOptionsReadOnlyKey, value);
    }

    public boolean isConnectionOptionsReadOnly() {
        return (Boolean)this.getControlProperty(ConnectionOptionsReadOnlyKey);
    }

    public synchronized void setConnectionOptionsResultSetHoldability(JdbcControl.HoldabilityType value) {
        this.setControlProperty(ConnectionOptionsResultSetHoldabilityKey, (Object)value);
    }

    public JdbcControl.HoldabilityType getConnectionOptionsResultSetHoldability() {
        return (JdbcControl.HoldabilityType)((Object)this.getControlProperty(ConnectionOptionsResultSetHoldabilityKey));
    }

    public synchronized void setConnectionOptionsTypeMappers(JdbcControl.TypeMapper[] value) {
        this.setControlProperty(ConnectionOptionsTypeMappersKey, value);
    }

    public JdbcControl.TypeMapper[] getConnectionOptionsTypeMappers() {
        return (JdbcControl.TypeMapper[])this.getControlProperty(ConnectionOptionsTypeMappersKey);
    }

    public synchronized void setTypeMapperUDTName(String value) {
        this.setControlProperty(TypeMapperUDTNameKey, value);
    }

    public String getTypeMapperUDTName() {
        return (String)this.getControlProperty(TypeMapperUDTNameKey);
    }

    public synchronized void setTypeMapperMapperClass(Class<? extends SQLData> value) {
        this.setControlProperty(TypeMapperMapperClassKey, value);
    }

    public Class<? extends SQLData> getTypeMapperMapperClass() {
        return (Class)this.getControlProperty(TypeMapperMapperClassKey);
    }

    public synchronized void setSQLStatement(String value) {
        this.setControlProperty(SQLStatementKey, value);
    }

    public String getSQLStatement() {
        return (String)this.getControlProperty(SQLStatementKey);
    }

    public synchronized void setSQLArrayMaxLength(int value) {
        this.setControlProperty(SQLArrayMaxLengthKey, value);
    }

    public int getSQLArrayMaxLength() {
        return (Integer)this.getControlProperty(SQLArrayMaxLengthKey);
    }

    public synchronized void setSQLMaxRows(int value) {
        this.setControlProperty(SQLMaxRowsKey, value);
    }

    public int getSQLMaxRows() {
        return (Integer)this.getControlProperty(SQLMaxRowsKey);
    }

    public synchronized void setSQLBatchUpdate(boolean value) {
        this.setControlProperty(SQLBatchUpdateKey, value);
    }

    public boolean isSQLBatchUpdate() {
        return (Boolean)this.getControlProperty(SQLBatchUpdateKey);
    }

    public synchronized void setSQLFetchSize(int value) {
        this.setControlProperty(SQLFetchSizeKey, value);
    }

    public int getSQLFetchSize() {
        return (Integer)this.getControlProperty(SQLFetchSizeKey);
    }

    public synchronized void setSQLFetchDirection(JdbcControl.FetchDirection value) {
        this.setControlProperty(SQLFetchDirectionKey, (Object)value);
    }

    public JdbcControl.FetchDirection getSQLFetchDirection() {
        return (JdbcControl.FetchDirection)((Object)this.getControlProperty(SQLFetchDirectionKey));
    }

    public synchronized void setSQLGetGeneratedKeys(boolean value) {
        this.setControlProperty(SQLGetGeneratedKeysKey, value);
    }

    public boolean isSQLGetGeneratedKeys() {
        return (Boolean)this.getControlProperty(SQLGetGeneratedKeysKey);
    }

    public synchronized void setSQLGeneratedKeyColumnNames(String[] value) {
        this.setControlProperty(SQLGeneratedKeyColumnNamesKey, value);
    }

    public String[] getSQLGeneratedKeyColumnNames() {
        return (String[])this.getControlProperty(SQLGeneratedKeyColumnNamesKey);
    }

    public synchronized void setSQLGeneratedKeyColumnIndexes(int[] value) {
        this.setControlProperty(SQLGeneratedKeyColumnIndexesKey, value);
    }

    public int[] getSQLGeneratedKeyColumnIndexes() {
        return (int[])this.getControlProperty(SQLGeneratedKeyColumnIndexesKey);
    }

    public synchronized void setSQLResultSetHoldabilityOverride(JdbcControl.HoldabilityType value) {
        this.setControlProperty(SQLResultSetHoldabilityOverrideKey, (Object)value);
    }

    public JdbcControl.HoldabilityType getSQLResultSetHoldabilityOverride() {
        return (JdbcControl.HoldabilityType)((Object)this.getControlProperty(SQLResultSetHoldabilityOverrideKey));
    }

    public synchronized void setSQLTypeMappersOverride(JdbcControl.TypeMapper[] value) {
        this.setControlProperty(SQLTypeMappersOverrideKey, value);
    }

    public JdbcControl.TypeMapper[] getSQLTypeMappersOverride() {
        return (JdbcControl.TypeMapper[])this.getControlProperty(SQLTypeMappersOverrideKey);
    }

    public synchronized void setSQLIteratorElementType(Class value) {
        this.setControlProperty(SQLIteratorElementTypeKey, value);
    }

    public Class getSQLIteratorElementType() {
        return (Class)this.getControlProperty(SQLIteratorElementTypeKey);
    }

    public synchronized void setSQLResultSetMapper(Class value) {
        this.setControlProperty(SQLResultSetMapperKey, value);
    }

    public Class getSQLResultSetMapper() {
        return (Class)this.getControlProperty(SQLResultSetMapperKey);
    }

    public synchronized void setSQLScrollableResultSet(JdbcControl.ScrollType value) {
        this.setControlProperty(SQLScrollableResultSetKey, (Object)value);
    }

    public JdbcControl.ScrollType getSQLScrollableResultSet() {
        return (JdbcControl.ScrollType)((Object)this.getControlProperty(SQLScrollableResultSetKey));
    }

    protected Map getPropertyMapCache() {
        return _annotCache;
    }

    static {
        _methodParamMap = new HashMap();
        try {
            _getConnectionMethod = JdbcControl.class.getMethod("getConnection", new Class[0]);
            _methodParamMap.put(_getConnectionMethod, new String[0]);
            _setDataSourceCalendarMethod = JdbcControl.class.getMethod("setDataSourceCalendar", Calendar.class);
            _methodParamMap.put(_setDataSourceCalendarMethod, new String[]{"cal"});
            _getDataSourceCalendarMethod = JdbcControl.class.getMethod("getDataSourceCalendar", new Class[0]);
            _methodParamMap.put(_getDataSourceCalendarMethod, new String[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
        ControlImplementationKey = new PropertyKey(BaseProperties.class, "controlImplementation");
        ConnectionDataSourceJndiNameKey = new PropertyKey(JdbcControl.ConnectionDataSource.class, "jndiName");
        ConnectionDataSourceJndiContextFactoryKey = new PropertyKey(JdbcControl.ConnectionDataSource.class, "jndiContextFactory");
        ConnectionDriverDatabaseDriverClassKey = new PropertyKey(JdbcControl.ConnectionDriver.class, "databaseDriverClass");
        ConnectionDriverDatabaseURLKey = new PropertyKey(JdbcControl.ConnectionDriver.class, "databaseURL");
        ConnectionDriverUserNameKey = new PropertyKey(JdbcControl.ConnectionDriver.class, "userName");
        ConnectionDriverPasswordKey = new PropertyKey(JdbcControl.ConnectionDriver.class, "password");
        ConnectionDriverPropertiesKey = new PropertyKey(JdbcControl.ConnectionDriver.class, "properties");
        ConnectionOptionsReadOnlyKey = new PropertyKey(JdbcControl.ConnectionOptions.class, "readOnly");
        ConnectionOptionsResultSetHoldabilityKey = new PropertyKey(JdbcControl.ConnectionOptions.class, "resultSetHoldability");
        ConnectionOptionsTypeMappersKey = new PropertyKey(JdbcControl.ConnectionOptions.class, "typeMappers");
        TypeMapperUDTNameKey = new PropertyKey(JdbcControl.TypeMapper.class, "UDTName");
        TypeMapperMapperClassKey = new PropertyKey(JdbcControl.TypeMapper.class, "mapperClass");
        SQLStatementKey = new PropertyKey(JdbcControl.SQL.class, "statement");
        SQLArrayMaxLengthKey = new PropertyKey(JdbcControl.SQL.class, "arrayMaxLength");
        SQLMaxRowsKey = new PropertyKey(JdbcControl.SQL.class, "maxRows");
        SQLBatchUpdateKey = new PropertyKey(JdbcControl.SQL.class, "batchUpdate");
        SQLFetchSizeKey = new PropertyKey(JdbcControl.SQL.class, "fetchSize");
        SQLFetchDirectionKey = new PropertyKey(JdbcControl.SQL.class, "fetchDirection");
        SQLGetGeneratedKeysKey = new PropertyKey(JdbcControl.SQL.class, "getGeneratedKeys");
        SQLGeneratedKeyColumnNamesKey = new PropertyKey(JdbcControl.SQL.class, "generatedKeyColumnNames");
        SQLGeneratedKeyColumnIndexesKey = new PropertyKey(JdbcControl.SQL.class, "generatedKeyColumnIndexes");
        SQLResultSetHoldabilityOverrideKey = new PropertyKey(JdbcControl.SQL.class, "resultSetHoldabilityOverride");
        SQLTypeMappersOverrideKey = new PropertyKey(JdbcControl.SQL.class, "typeMappersOverride");
        SQLIteratorElementTypeKey = new PropertyKey(JdbcControl.SQL.class, "iteratorElementType");
        SQLResultSetMapperKey = new PropertyKey(JdbcControl.SQL.class, "resultSetMapper");
        SQLScrollableResultSetKey = new PropertyKey(JdbcControl.SQL.class, "scrollableResultSet");
        _annotCache = new HashMap();
    }
}

