/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.sql.Connection;
import java.sql.SQLData;
import java.sql.SQLException;
import java.util.Calendar;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.beehive.controls.api.bean.AnnotationConstraints;
import org.apache.beehive.controls.api.bean.AnnotationMemberTypes;
import org.apache.beehive.controls.api.bean.ControlInterface;
import org.apache.beehive.controls.api.properties.PropertySet;
import org.apache.beehive.controls.system.jdbc.DefaultJndiContextFactory;
import org.apache.beehive.controls.system.jdbc.JdbcControlChecker;

@ControlInterface(checker=JdbcControlChecker.class)
public interface JdbcControl {
    public static final int MAXROWS_ALL = 0;
    public static final int DEFAULT_FETCH_SIZE = 0;

    public Connection getConnection() throws SQLException;

    public void setDataSourceCalendar(Calendar var1);

    public Calendar getDataSourceCalendar();

    public static class SQLParameter {
        public static final int IN = 1;
        public static final int OUT = 2;
        public static final int INOUT = 3;
        public Object value = null;
        public int type = 0;
        public int dir = 1;

        public SQLParameter(Object value) {
            this.value = value;
        }

        public SQLParameter(Object value, int type) {
            this(value);
            this.type = type;
        }

        public SQLParameter(Object value, int type, int dir) {
            this(value, type);
            this.dir = dir;
        }

        public Object clone() {
            return new SQLParameter(this.value, this.type, this.dir);
        }
    }

    @PropertySet(prefix="SQL")
    @Inherited
    @Retention(value=RetentionPolicy.RUNTIME)
    @AnnotationConstraints.AllowExternalOverride
    @Target(value={ElementType.METHOD})
    public static @interface SQL {
        public String statement();

        @AnnotationMemberTypes.Optional
        public int arrayMaxLength() default 1024;

        @AnnotationMemberTypes.Optional
        public int maxRows() default 0;

        @AnnotationMemberTypes.Optional
        public boolean batchUpdate() default false;

        @AnnotationMemberTypes.Optional
        public int fetchSize() default 0;

        @AnnotationMemberTypes.Optional
        public FetchDirection fetchDirection() default FetchDirection.FORWARD;

        @AnnotationMemberTypes.Optional
        public boolean getGeneratedKeys() default false;

        @AnnotationMemberTypes.Optional
        public String[] generatedKeyColumnNames() default {};

        @AnnotationMemberTypes.Optional
        public int[] generatedKeyColumnIndexes() default {};

        @AnnotationMemberTypes.Optional
        public HoldabilityType resultSetHoldabilityOverride() default HoldabilityType.DRIVER_DEFAULT;

        @AnnotationMemberTypes.Optional
        public TypeMapper[] typeMappersOverride() default {};

        @AnnotationMemberTypes.Optional
        public Class iteratorElementType() default UndefinedIteratorType.class;

        @AnnotationMemberTypes.Optional
        public Class resultSetMapper() default UndefinedResultSetMapper.class;

        @AnnotationMemberTypes.Optional
        public ScrollType scrollableResultSet() default ScrollType.DRIVER_DEFAULT;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HoldabilityType {
        DRIVER_DEFAULT(0),
        HOLD_CURSORS(1),
        CLOSE_CURSORS(2);

        private final int _holdability;

        private HoldabilityType(int holdability) {
            this._holdability = holdability;
        }

        public int getHoldability() {
            return this._holdability;
        }

        public String toString() {
            if (this._holdability == 1) {
                return "HOLD_CURSORS_OVER_COMMIT";
            }
            if (this._holdability == 2) {
                return "CLOSE_CURSORS_AT_COMMIT";
            }
            return "Default driver holdability";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FetchDirection {
        FORWARD(1000),
        REVERSE(1001),
        UNKNOWN(1002);

        private final int _direction;

        private FetchDirection(int direction) {
            this._direction = direction;
        }

        public int getDirection() {
            return this._direction;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ScrollType {
        DRIVER_DEFAULT(-1, -1),
        FORWARD_ONLY(1003, 1007),
        SCROLL_INSENSITIVE(1004, 1007),
        SCROLL_SENSITIVE(1005, 1007),
        FORWARD_ONLY_UPDATABLE(1003, 1008),
        SCROLL_INSENSITIVE_UPDATABLE(1004, 1008),
        SCROLL_SENSITIVE_UPDATABLE(1005, 1008);

        private final int _type;
        private final int _concurrencyType;

        private ScrollType(int scrollType, int concurrencyType) {
            this._type = scrollType;
            this._concurrencyType = concurrencyType;
        }

        public int getType() {
            return this._type;
        }

        public int getConcurrencyType() {
            return this._concurrencyType;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this._type == 1003) {
                sb.append("Foward Only, ");
            } else if (this._type == 1004) {
                sb.append("Scroll Insensitive, ");
            } else if (this._type == 1005) {
                sb.append("Scroll Sensitive, ");
            } else {
                sb.append("Jdbc Driver Default Direction");
            }
            if (this._concurrencyType == 1007) {
                sb.append("Read Only");
            } else if (this._concurrencyType == 1008) {
                sb.append("Updatable");
            } else {
                sb.append("Jdbc Driver Default");
            }
            return sb.toString();
        }
    }

    public static interface UndefinedResultSetMapper {
    }

    public static interface UndefinedIteratorType {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PropertySet(prefix="TypeMapper")
    @Inherited
    @AnnotationConstraints.AllowExternalOverride
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.METHOD})
    public static @interface TypeMapper {
        public String UDTName();

        public Class<? extends SQLData> mapperClass();
    }

    @PropertySet(prefix="ConnectionOptions")
    @Inherited
    @AnnotationConstraints.AllowExternalOverride
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface ConnectionOptions {
        @AnnotationMemberTypes.Optional
        public boolean readOnly() default false;

        @AnnotationMemberTypes.Optional
        public HoldabilityType resultSetHoldability() default HoldabilityType.DRIVER_DEFAULT;

        @AnnotationMemberTypes.Optional
        public TypeMapper[] typeMappers() default {};
    }

    @PropertySet(prefix="ConnectionDriver")
    @Inherited
    @AnnotationConstraints.AllowExternalOverride
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface ConnectionDriver {
        public String databaseDriverClass();

        public String databaseURL();

        @AnnotationMemberTypes.Optional
        public String userName() default "";

        @AnnotationMemberTypes.Optional
        public String password() default "";

        @AnnotationMemberTypes.Optional
        public String properties() default "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @PropertySet(prefix="ConnectionDataSource")
    @Inherited
    @AnnotationConstraints.AllowExternalOverride
    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE, ElementType.FIELD})
    public static @interface ConnectionDataSource {
        @AnnotationMemberTypes.JndiName(resourceType=AnnotationMemberTypes.JndiName.ResourceType.DATASOURCE)
        public String jndiName();

        @AnnotationMemberTypes.Optional
        public Class<? extends JndiContextFactory> jndiContextFactory() default DefaultJndiContextFactory.class;
    }

    public static abstract class JndiContextFactory {
        public abstract Context getContext() throws NamingException;
    }
}

