/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beehive.controls.system.jdbc;

import com.sun.rowset.CachedRowSetImpl;
import java.lang.reflect.Method;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import javax.sql.RowSet;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.system.jdbc.JdbcControl;
import org.apache.beehive.controls.system.jdbc.ResultSetMapper;
import org.apache.beehive.controls.system.jdbc.TypeMappingsFactory;

public class DefaultRowSetResultSetMapper
extends ResultSetMapper {
    private static final TypeMappingsFactory _tmf = TypeMappingsFactory.getInstance();

    public RowSet mapToResultType(ControlBeanContext context, Method m, ResultSet resultSet, Calendar cal) {
        JdbcControl.SQL methodSQL = (JdbcControl.SQL)context.getMethodPropertySet(m, JdbcControl.SQL.class);
        int maxrows = methodSQL.maxRows();
        try {
            CachedRowSetImpl rows = new CachedRowSetImpl();
            if (maxrows > 0) {
                rows.setMaxRows(maxrows);
            }
            rows.populate(resultSet);
            return rows;
        }
        catch (SQLException e) {
            throw new ControlException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean canCloseResultSet() {
        return false;
    }
}

